/**
 ** POLYTEST.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "test.h"
#include <string.h>

static int red;

extern long clock();

unsigned char mybits[] = { 0x88, 0x44, 0x22, 0x11 };
GrBitmap mybitmap = { 0, 4, mybits };

GrPattern *p1;
GrPattern *p2 = (GrPattern *)&mybitmap;

static void initpatterns(void)
{
	GrContext tmp,save;
	GrFBoxColors bc;

	mybitmap.bmp_fgcolor = GrAllocColor(255,0,0);
	mybitmap.bmp_bgcolor = GrNOCOLOR;

	GrCreateContext(20,20,NULL,&tmp);
	GrSaveContext(&save);
	GrSetContext(&tmp);
	bc.fbx_intcolor = GrAllocColor(0,140,140);
	bc.fbx_leftcolor = bc.fbx_topcolor = GrAllocColor(0,200,200);
	bc.fbx_rightcolor = bc.fbx_bottomcolor = GrAllocColor(0,80,80);
	GrFramedBox(2,2,17,17,2,&bc);
	p1 = GrConvertToPixmap(&tmp);
	GrSetContext(&save);
}

static void testpoly(int n,int points[][2])
{
	GrClearScreen(GrBlack());
	GrSetClipBox(100,100,700,500);
	GrFilledPolygon(n,points,red);
	GrSetClipBox(0,0,GrMaxX(),GrMaxY());
	GrBox(99,99,701,501,GrWhite() | GrXOR);
	GrPolygon(n,points,GrWhite() | GrXOR);
	getkey();
	GrClearScreen(GrBlack());
	GrPatternFilledPolygon(n,points,p1);
	getkey();
	GrPatternFilledPolygon(n,points,p2);
	getkey();
	if(n <= 3) {
	    GrClearScreen(GrBlack());
	    GrFilledPolygon(n,points,red);
	    GrFilledConvexPolygon(n,points,GrWhite() | GrXOR);
	    getkey();
	}
}

static void speedtest(void)
{
	int pts[4][2];
	int ww = GrSizeX() / 10;
	int hh = GrSizeY() / 10;
	int sx = (GrSizeX() - 2*ww) / 32;
	int sy = (GrSizeY() - 2*hh) / 32;
	int ii,jj,color;
	long t1,t2,t3;

	GrClearScreen(GrBlack());
	t1 = clock();
	pts[0][1] = 0;
	pts[1][1] = hh;
	pts[2][1] = 2*hh;
	pts[3][1] = hh;
	color = 0;
	for(ii = 0; ii < 32; ii++) {
	    pts[0][0] = ww;
	    pts[1][0] = 2*ww;
	    pts[2][0] = ww;
	    pts[3][0] = 0;
	    for(jj = 0; jj < 32; jj++) {
		GrFilledPolygon(4,pts,color | GrXOR);
		color = (color + 1) & 15;
		pts[0][0] += sx;
		pts[1][0] += sx;
		pts[2][0] += sx;
		pts[3][0] += sx;
	    }
	    pts[0][1] += sy;
	    pts[1][1] += sy;
	    pts[2][1] += sy;
	    pts[3][1] += sy;
	}
	t2 = clock();
	pts[0][1] = 0;
	pts[1][1] = hh;
	pts[2][1] = 2*hh;
	pts[3][1] = hh;
	color = 0;
	for(ii = 0; ii < 32; ii++) {
	    pts[0][0] = ww;
	    pts[1][0] = 2*ww;
	    pts[2][0] = ww;
	    pts[3][0] = 0;
	    for(jj = 0; jj < 32; jj++) {
		GrFilledConvexPolygon(4,pts,color | GrXOR);
		color = (color + 1) & 15;
		pts[0][0] += sx;
		pts[1][0] += sx;
		pts[2][0] += sx;
		pts[3][0] += sx;
	    }
	    pts[0][1] += sy;
	    pts[1][1] += sy;
	    pts[2][1] += sy;
	    pts[3][1] += sy;
	}
	t3 = clock();
	sprintf(exit_message,
	    "Times to scan 1024 polygons\n"
	    "   with 'GrFilledPolygon': %.2f (s)\n"
	    "   with 'GrFilledConvexPolygon': %.2f (s)\n",
	    (double)(t2 - t1) / 18.2,
	    (double)(t3 - t2) / 18.2
	);
}

TESTFUNC(ptest)
{
	char buff[300];
	int  pts[300][2];
	int  ii,collect;
	FILE *fp;

	fp = fopen("polytest.dat","r");
	if(fp == NULL) return;
	collect = 0;
	red = GrAllocColor(255,0,0);
	GrSetColor((red ^ GrWhite()),0,50,255);
	initpatterns();
	while(fgets(buff,299,fp) != NULL) {
	    if(!collect) {
		if(strncmp(buff,"begin",5) == 0) {
		    collect = 1;
		    ii = 0;
		}
		continue;
	    }
	    if(strncmp(buff,"end",3) == 0) {
		testpoly(ii,pts);
		collect = 0;
		continue;
	    }
	    if(sscanf(buff,"%d %d",&pts[ii][0],&pts[ii][1]) == 2) ii++;
	}
	speedtest();
}

