
/* ------------------------------------------------------------------- */
/* ----                     New demo routines                     ---- */
/* ------------------------------------------------------------------- */


int _max(int a, int b)
{
  return ( a>b ? a : b );
}

int _min(int a, int b)
{
  return ( a<b ? a : b );
}

void ShiftDac(char pal[][3])
{
  int r,g,b;
  int k, l;

  for (k=0;k<=1;k++) {
    r=pal[254][0];
    g=pal[254][1];
    b=pal[254][2];
    for (l=254;l>=1;l--) {
      pal[l][0]=pal[l-1][0];
      pal[l][1]=pal[l-1][1];
      pal[l][2]=pal[l-1][2];
    }
    pal[1][0]=r;
    pal[1][1]=g;
    pal[1][2]=b;
  }
  for (k=0;k<=255;k++)
    setrgbpalette(k,pal[k][0],pal[k][1],pal[k][2]);
}

void PlayRGBpalette(void)
/* This is partially copyrighted by COPYRIGHT(C) 1990 by H+BEDV  */
{
  typedef char _PAL[256][3];

  int x,c, m, maxx, maxy, radius, height, ycenter;
  float pc;
  _PAL cpal;
  struct viewporttype     viewinfo;

  if ( getmaxcolor() != 255) return;

  for (c=0;c<=255;c++) {
    m= (c*3)>>1;
    if ((m<64)) {
      cpal[c][0]=63;
      cpal[c][1]=m;
      cpal[c][2]=0;
    }
    if ((m>63) && (m<128)) {
      cpal[c][0]=127-m;
      cpal[c][1]=63;
      cpal[c][2]=0;
    }
    if ((m>127) && (m<192)) {
      cpal[c][0]=0;
      cpal[c][1]=63;
      cpal[c][2]=m-128;
    }
    if ((m>191) && (m<256)) {
      cpal[c][0]=0;
      cpal[c][1]=255-m;
      cpal[c][2]=63;
    }
    if ((m>255) && (m<320)) {
      cpal[c][0]=m-256;
      cpal[c][1]=0;
      cpal[c][2]=63;
    }
    if ((m>319)) {
      cpal[c][0]=63;
      cpal[c][1]=0;
      cpal[c][2]=383-m;
    }
  }
  cpal[0][0]=0;
  cpal[0][1]=0;
  cpal[0][2]=0;
  cpal[255][0]=63;
  cpal[255][1]=63;
  cpal[255][2]=63;
  ShiftDac( cpal);

  MainWindowColor( "Play RGB palette", 255);
  getviewsettings( &viewinfo );
  maxx = abs(viewinfo.right-viewinfo.left)-1;
  maxy = abs(viewinfo.top-viewinfo.bottom)-1;
  setcolor(255);

  height = maxy/8;
  c=1;
  for (x=5; x <= maxx+1-5; ++x) {
    setcolor(c);
    if (++c > 254) c = 1;
    line(x,maxy-5,x,maxy-5-height);
  }

  pc=1.0;
  ycenter = (maxy-5-height) / 2;
  radius = _min((int)((maxy-5-height)/AspectRatio), maxx)*9/20;
  for (x=0;x<=356;x++) {
    setcolor(pc);
    setfillstyle(SOLID_FILL,pc);
    pieslice(maxx/2,ycenter,x,x+4,radius);
    pc=pc+254.0/360.0;
  }

  StatusLineColor( StopMsg, 255);

  do {
    ShiftDac(cpal);
  } while (!(kbhit()));
  getch();
  for (c=1; c < 255; ++c) {
    cpal[c][0] = _dac_g256[c][0];
    cpal[c][1] = _dac_g256[c][1];
    cpal[c][2] = _dac_g256[c][2];
  }

  StatusLineColor( PauseMsg, 255);
  do {
    ShiftDac(cpal);
  } while (!(kbhit()));

  setbkcolor(BLACK);
  clearviewport();
  setrgbdefaults();
  Pause();                              /* Pause for user to read screen*/
}

/* The Sierpinski demo was mainly taken from
   N. Wirth: Algorithmen und Datenstrukturen  */
#define SIRP_N     4
#define SIRP_H0    320

static int SIRP_x, SIRP_y, h;

static void SIRP_a(int i);
static void SIRP_b(int i);
static void SIRP_c(int i);
static void SIRP_d(int i);

static void SIRP_a(int i)
{
  if (i>0) {
    SIRP_a(i-1); SIRP_x += h;   SIRP_y -= h; lineto( SIRP_x, SIRP_y);
    SIRP_b(i-1); SIRP_x += 2*h;              lineto( SIRP_x, SIRP_y);
    SIRP_d(i-1); SIRP_x += h;   SIRP_y += h; lineto( SIRP_x, SIRP_y);
    SIRP_a(i-1);
  }
}

static void SIRP_b(int i)
{
  if (i>0) {
    SIRP_b(i-1); SIRP_x -= h; SIRP_y -= h;   lineto( SIRP_x, SIRP_y);
    SIRP_c(i-1);              SIRP_y -= 2*h; lineto( SIRP_x, SIRP_y);
    SIRP_a(i-1); SIRP_x += h; SIRP_y -= h;   lineto( SIRP_x, SIRP_y);
    SIRP_b(i-1);
  }
}

static void SIRP_c(int i)
{
  if (i>0) {
    SIRP_c(i-1); SIRP_x -= h;   SIRP_y += h; lineto( SIRP_x, SIRP_y);
    SIRP_d(i-1); SIRP_x -= 2*h;              lineto( SIRP_x, SIRP_y);
    SIRP_b(i-1); SIRP_x -= h;   SIRP_y -= h; lineto( SIRP_x, SIRP_y);
    SIRP_c(i-1);
  }
}

static void SIRP_d(int i)
{
  if (i>0) {
    SIRP_d(i-1); SIRP_x += h; SIRP_y += h;   lineto( SIRP_x, SIRP_y);
    SIRP_a(i-1);              SIRP_y += 2*h; lineto( SIRP_x, SIRP_y);
    SIRP_c(i-1); SIRP_x -= h; SIRP_y += h;   lineto( SIRP_x, SIRP_y);
    SIRP_d(i-1);
  }
}

void sierpinski(void)
{
  int i, h0, x0, y0, bx, by;
  int border, color;
  struct viewporttype vp;
  struct fillsettingstype fs;

  MainWindow( "Floodfill demo");
  StatusLine(PauseMsg);
  getviewsettings( &vp);
  getfillsettings( &fs);

  setviewport( (bx=_max((getmaxx() - SIRP_H0) / 2, vp.left)),
	       (by=_max((getmaxy() - SIRP_H0) / 2, vp.top)),
	       _min((getmaxx() + SIRP_H0) / 2 + 5, vp.right),
	       _min((getmaxy() + SIRP_H0) / 2 + 5, vp.bottom),
	       TRUE );

  switch (random(6)) {
    case 0 : border = LIGHTCYAN;  break;
    case 1 : border = YELLOW;     break;
    case 2 : border = RED;        break;
    case 3 : border = GREEN;      break;
    case 4 : border = BLUE;       break;
    default: border = WHITE;      break;
  }
  setcolor( border);
  h0 = SIRP_H0;
  h = h0 / 4;
  x0 = 2*h;
  y0 = 3*h;
  for (i=1; i <= SIRP_N; ++i) {
    x0 -= h;
    h /= 2;
    y0 += h;
    SIRP_x = x0; SIRP_y = y0;
    moveto( SIRP_x, SIRP_y);
    SIRP_a(i); SIRP_x += h; SIRP_y -= h; lineto(SIRP_x,SIRP_y);
    SIRP_b(i); SIRP_x -= h; SIRP_y -= h; lineto(SIRP_x,SIRP_y);
    SIRP_c(i); SIRP_x -= h; SIRP_y += h; lineto(SIRP_x,SIRP_y);
    SIRP_d(i); SIRP_x += h; SIRP_y += h; lineto(SIRP_x,SIRP_y);
  }
  setviewport( vp.left, vp.top, vp.right, vp.bottom, vp.clip);
  bx += h0/2 - vp.left;
  by += h0/2 - vp.top;
  do {
    do
      color = random(getmaxcolor()+1);
    while (color == WHITE || color == BLACK || color == border);
    setfillstyle(random(USER_FILL-1)+1, color);
    floodfill( bx, by, border);
    floodfill(  1,  1, border);
  } while ( !kbhit());
  setfillstyle( fs.pattern, fs.color);

  Pause();                              /* Pause for user to read screen*/
}

void RandomSolidBars(void)
{
  int color;

  MainWindow( "Random Solid/Line Bars" );
  StatusLine( PauseMsg );               /* Put msg at bottom of screen   */
  while( !kbhit() ){                    /* Until user enters a key...   */
    color = random( MaxColors-1 )+1;
    setcolor( color );
    /* SOLID_FILL && LINE_FILL are much faster */
    setfillstyle( SOLID_FILL+random(2), color );
    bar3d( random( getmaxx() ), random( getmaxy() ),
	   random( getmaxx() ), random( getmaxy() ), 0, OFF);
  }

  Pause();                              /* Pause for user's response    */

}

#define Memory          100
#define Windows         4

typedef int ColorList[Windows];


typedef struct _REC_Line {
  int LX1, LY1, LX2, LY2;
  ColorList LColor;
} _REC_Line;

/* Local variables for LinePlay: */
struct LOC_LinePlay {
  int ViewXmax, ViewYmax;
  _REC_Line Line[Memory];
  int X1, X2, Y1, Y2, CurrentLine, ColorCount, IncrementCount, DeltaX1,
      DeltaY1, DeltaX2, DeltaY2;
  ColorList Colors;
  int MaxDelta;
} ;

void AdjustX(int *X, int *DeltaX, struct LOC_LinePlay *LINK)
{
  int TestX;

  TestX = *X + *DeltaX;
  if (TestX < 1 || TestX > LINK->ViewXmax) {
    TestX = *X;
    *DeltaX = -*DeltaX;
  }
  *X = TestX;
}

void AdjustY(int *Y, int *DeltaY, struct LOC_LinePlay *LINK)
{
  int TestY;

  TestY = *Y + *DeltaY;
  if (TestY < 1 || TestY > LINK->ViewYmax) {
    TestY = *Y;
    *DeltaY = -*DeltaY;
  }
  *Y = TestY;
}

int RandColor(void)
{
  return random(MaxColors) + 1;
}

void SelectNewColors(struct LOC_LinePlay *LINK)
{
  LINK->Colors[0] = RandColor();
  LINK->Colors[1] = RandColor();
  LINK->Colors[2] = RandColor();
  LINK->Colors[3] = RandColor();
  LINK->ColorCount = (random(5) + 1) * 3;
}

void SelectNewDeltaValues(struct LOC_LinePlay *LINK)
{
  LINK->DeltaX1 = random(LINK->MaxDelta) - LINK->MaxDelta / 2;
  LINK->DeltaX2 = random(LINK->MaxDelta) - LINK->MaxDelta / 2;
  LINK->DeltaY1 = random(LINK->MaxDelta) - LINK->MaxDelta / 2;
  LINK->DeltaY2 = random(LINK->MaxDelta) - LINK->MaxDelta / 2;
  LINK->IncrementCount = (random(4) + 1) * 2;
}

void SaveCurrentLine(int *CurrentColors, struct LOC_LinePlay *LINK)
{
  _REC_Line *WITH;

  WITH = &LINK->Line[LINK->CurrentLine - 1];
  WITH->LX1 = LINK->X1;
  WITH->LY1 = LINK->Y1;
  WITH->LX2 = LINK->X2;
  WITH->LY2 = LINK->Y2;
  memcpy(WITH->LColor, CurrentColors, sizeof(ColorList));
}

void Draw(unsigned short x1, unsigned short y1, unsigned short x2,
		unsigned short y2, unsigned short color)
{
  setcolor(color);
  line(x1, y1, x2, y2);
}

void Updateline(struct LOC_LinePlay *LINK)
{
  LINK->CurrentLine++;
  if (LINK->CurrentLine > Memory)
    LINK->CurrentLine = 1;
  LINK->ColorCount--;
  LINK->IncrementCount--;
}

void DrawCurrentLine(struct LOC_LinePlay *LINK)
{
  Draw(LINK->X1, LINK->Y1, LINK->X2, LINK->Y2, LINK->Colors[0]);
  Draw(LINK->ViewXmax - LINK->X1, LINK->Y1, LINK->ViewXmax - LINK->X2,
       LINK->Y2, LINK->Colors[1]);
  Draw(LINK->X1, LINK->ViewYmax - LINK->Y1, LINK->X2,
       LINK->ViewYmax - LINK->Y2, LINK->Colors[2]);
  Draw(LINK->ViewXmax - LINK->X1, LINK->ViewYmax - LINK->Y1,
       LINK->ViewXmax - LINK->X2, LINK->ViewYmax - LINK->Y2, LINK->Colors[3]);
  SaveCurrentLine(LINK->Colors, LINK);
}

void EraseCurrentLine(struct LOC_LinePlay *LINK)
{
  _REC_Line *WITH;

  WITH = &LINK->Line[LINK->CurrentLine - 1];
  Draw(WITH->LX1, WITH->LY1, WITH->LX2, WITH->LY2, 0);
  Draw(LINK->ViewXmax - WITH->LX1, WITH->LY1, LINK->ViewXmax - WITH->LX2,
       WITH->LY2, 0);
  Draw(WITH->LX1, LINK->ViewYmax - WITH->LY1, WITH->LX2,
       LINK->ViewYmax - WITH->LY2, 0);
  Draw(LINK->ViewXmax - WITH->LX1, LINK->ViewYmax - WITH->LY1,
       LINK->ViewXmax - WITH->LX2, LINK->ViewYmax - WITH->LY2, 0);
}

void DoArt(struct LOC_LinePlay *LINK)
{
  SelectNewColors(LINK);
  do {
    EraseCurrentLine(LINK);
    if (LINK->ColorCount == 0)
      SelectNewColors(LINK);
    if (LINK->IncrementCount == 0)
      SelectNewDeltaValues(LINK);
    AdjustX(&LINK->X1, &LINK->DeltaX1, LINK);
    AdjustX(&LINK->X2, &LINK->DeltaX2, LINK);
    AdjustY(&LINK->Y1, &LINK->DeltaY1, LINK);
    AdjustY(&LINK->Y2, &LINK->DeltaY2, LINK);
    if (random(5) == 3) {
      LINK->X1 = (LINK->X1 + LINK->X2) / 2;   /* shorten the lines */
      LINK->Y2 = (LINK->Y1 + LINK->Y2) / 2;
    }
    DrawCurrentLine(LINK);
    Updateline(LINK);
  } while (!kbhit());
}


void LinePlay(void)
{
  struct LOC_LinePlay V;
  struct viewporttype ViewInfo;
  int StartX, StartY, I;
  _REC_Line *WITH;

  MainWindow("Line demonstration");
  StatusLine("Esc aborts or press a key ...");
  getviewsettings(&ViewInfo);
  V.CurrentLine = 1;
  V.ColorCount = 0;
  V.IncrementCount = 0;
  V.MaxDelta = 16;
  V.ViewXmax = ViewInfo.right - 1;
  V.ViewYmax = ViewInfo.bottom - 3;
  StartX = ViewInfo.right / 2;
  StartY = ViewInfo.bottom / 2;
  for (I = 0; I < Memory; I++) {
    WITH = &V.Line[I];
    WITH->LX1 = StartX;
    WITH->LX2 = StartX;
    WITH->LY1 = StartY;
    WITH->LY2 = StartY;
  }
  V.X1 = StartX;
  V.X2 = StartX;
  V.Y1 = StartY;
  V.Y2 = StartY;
  DoArt(&V);
  Pause();
}

#undef Memory
#undef Windows

/* Local variables for ColorPlay: */
struct LOC_ColorPlay {
  unsigned short Color, Width, Height;
  struct viewporttype ViewInfo;
} ;

char *Int2Str(char *Result, long L)
{
  /* Converts an integer to a string for use with OutText, OutTextXY */
  char S[256];

  sprintf(S, "%ld", L);
  return strcpy(Result, S);
}  /* Int2Str */


void DrawBox__(unsigned short X, unsigned short Y,
		     struct LOC_ColorPlay *LINK)
{
  int bottom;
  char STR1[256];

  setfillstyle(SOLID_FILL, LINK->Color);
  setcolor(LINK->Color);
  if (LINK->Height / 2 >= textheight("M") + 4)
    bottom = Y + LINK->Height;
  else
    bottom = Y + LINK->Height / 2 * 3 - textheight("M") - 5;
  bar(X, Y, X + LINK->Width, bottom);
  rectangle(X, Y, X + LINK->Width, bottom);
  LINK->Color = getcolor();
  if (LINK->Color == 0) {
    setcolor(MaxColors);
    rectangle(X, Y, X + LINK->Width, bottom);
  }
  setcolor(WHITE);
  outtextxy(X + LINK->Width / 2, bottom + 3, Int2Str(STR1, LINK->Color));
  LINK->Color = (LINK->Color + 1) % (MaxColors + 1);
}  /* DrawBox */


void ColorPlay(void)
{
  /* Display all of the colors available for the current driver and mode */
  struct LOC_ColorPlay V;
  unsigned short X, Y, I, J;

  if (MaxColors != 256) {
    ColorDemo();
    return;
  }
  MainWindow("Color demonstration");
  V.Color = 1;
  getviewsettings(&V.ViewInfo);
  V.Width = (V.ViewInfo.right + 1) / 53 * 2;
  V.Height = (V.ViewInfo.bottom - 10) / 47 * 2;
  if (V.Height < textheight("M") + 4)
    V.Height = textheight("M") + 4;
  if (V.Width < textwidth("M") * 2)
    V.Width = textwidth("M") * 2;
  X = V.Width / 2;
  Y = V.Height / 2;
  for (J = 1; J <= 15; J++) {
    for (I = 1; I <= 17; I++) {
      if (!kbhit())
        DrawBox__(X, Y, &V);
      X += V.Width / 2 * 3;
    }
    X = V.Width / 2;
    Y += V.Height / 2 * 3;
  }
  Pause();
}  /* ColorPlay */



