/** 
 ** CLIPTEST.C 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/


#include "test.h"

TESTFUNC(cliptest)
{
	long delay;
	int x = GrSizeX();
	int y = GrSizeY();
	int ww = (x * 2) / 3;
	int wh = (y * 2) / 3;
	int c;

	c = GrAllocColor(200,100,100);
	GrBox(ww/4-1,wh/4-1,ww/4+ww+1,wh/4+wh+1,GrWhite());
	GrSetClipBox(ww/4,wh/4,ww/4+ww,wh/4+wh);

	drawing(0,0,ww,wh,c,GrBlack());
	getkey();

	while(!kbhit()) {
	    GrFilledBox(0,0,x,y,GrBlack());
	    drawing(-(random()%(2*ww))+ww/2,
		-(random()%(2*wh))+wh/2,
		random()%(3*ww)+10,
		random()%(3*wh)+10,
		c,
		GrNOCOLOR
	    );
	    for(delay = 200000L; delay > 0L; delay--);
	}
	getkey();
}

