/**
 ** BLITTEST.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/


#include "test.h"
#include <stdlib.h>
#include <string.h>

int BWW = 83;
int BHH = 50;

void drbox(GrContext *src,int x,int y)
{
	int c1 = GrAllocColor(0,0,255);
	int c2 = GrAllocColor(255,255,0);
	int xx;

	GrClearScreen(c1);
	GrSetContext(src);
	GrSetClipBox(x-10,y-10,x+BWW-1+10,y+BHH-1+10);
	GrClearClipBox(c2);
	GrSetClipBox(x,y,x+BWW-1,y+BHH-1);
	GrClearClipBox(GrBlack());
	GrBox(x,y,x+BWW-1,y+BHH-1,GrWhite());
	for(xx = x; xx < x+BWW; xx += 5) {
	    GrLine(xx,y,xx+BHH,y+BHH,GrWhite());
	    GrLine(xx,y,xx-BHH,y+BHH,GrWhite());
	}
	GrSetContext(NULL);
	GrResetClipBox();
}

void doblits(GrContext *src,int x,int y)
{
	int xx = 300;
	int yy = 20;
	int ii;

	GrSetContext(NULL);
	for(ii = 0; ii < 8; ii++) {
	    GrBitBlt(NULL,xx,yy,src,x,y,x+BWW-1,y+BHH-1,GrWRITE);
	    xx++;
	    yy += (BHH + 5);
	}
}

void bltest(GrContext *src,int x,int y)
{
	int ii;

	for(ii = 0; ii < 8; ii++) {
	    drbox(src,x,y);
	    doblits(src,x,y);
	    getkey();
	    x++;
	}
}

void blxtest(void)
{
	GrContext memc;
	int cw = (BWW + 28) & ~7;
	int ch = BHH + 20;

	bltest(NULL,GrScreenX()-BWW-8,GrScreenY()-BHH);
	bltest(NULL,0,0);
#ifdef __GNUC__
	{
	    /*
	     * test stray memory references after the end of a context!!
	     */
	    long size = GrContextSize(cw,ch);
	    char *ptr = (char *)(((int)sbrk(0) + 10000 + size) & ~ 4095) - 1;

	    brk(ptr);
	    GrCreateContext(cw,ch,(ptr + 1 - size),&memc);
	    bltest(&memc,cw-BWW-8,ch-BHH);
	    /*
	     * prove that the next byte is really inaccessible
	     */
	    if((Argc > 0) && (strcmp(Argv[0],"crash") == 0)) {
		Argc |= *ptr++;		/* should be OK */
		Argc |= *ptr++;		/* should crash */
	    }
	}
#endif
#ifdef __TURBOC__
	GrCreateContext(cw,ch,NULL,&memc);
	bltest(&memc,cw-BWW-8,ch-BHH);
#endif
}

TESTFUNC(blittest)
{
	int x = GrSizeX();
	int y = GrSizeY();
	int ww = (x * 2) / 3;
	int wh = (y * 2) / 3;
	int c,ii,jj,bg;
	GrFBoxColors bcolors,ocolors,icolors;
	int wdt = ww / 150;
	int bw = x / 17;
	int bh = y / 17;
	int bx,by;

	GrContext *save;
	GrContext *tile;

	save = GrCreateSubContext(0,0,GrMaxX(),GrMaxY(),NULL,NULL);
	tile = GrCreateContext(bw,bh,NULL,NULL);

	blxtest();
	BWW = 3;
	blxtest();

	bcolors.fbx_intcolor = GrAllocColor(160,100,30);
	bcolors.fbx_topcolor = GrAllocColor(240,150,45);
	bcolors.fbx_leftcolor = GrAllocColor(240,150,45);
	bcolors.fbx_rightcolor = GrAllocColor(80,50,15);
	bcolors.fbx_bottomcolor = GrAllocColor(80,50,15);

	ocolors.fbx_intcolor = GrAllocColor(0,120,100);
	ocolors.fbx_topcolor = GrAllocColor(0,180,150);
	ocolors.fbx_leftcolor = GrAllocColor(0,180,150);
	ocolors.fbx_rightcolor = GrAllocColor(0,90,60);
	ocolors.fbx_bottomcolor = GrAllocColor(0,90,60);

	icolors.fbx_intcolor = bg = GrAllocColor(30,30,30);
	icolors.fbx_bottomcolor = GrAllocColor(0,180,150);
	icolors.fbx_rightcolor = GrAllocColor(0,180,150);
	icolors.fbx_leftcolor = GrAllocColor(0,90,60);
	icolors.fbx_topcolor = GrAllocColor(0,90,60);

	c = GrAllocColor(250,250,0);

	for(ii = 0,by = -(bh/3); ii < 18; ii++) {
	    for(jj = 0,bx = -(bw/2); jj < 18; jj++) {
		GrFramedBox(bx+2*wdt,by+2*wdt,bx+bw-2*wdt-1,by+bh-2*wdt-1,2*wdt,&bcolors);
		bx += bw;
	    }
	    by += bh;
	}

	GrFramedBox(ww/4-5*wdt-1,wh/4-5*wdt-1,ww/4+5*wdt+ww+1,wh/4+5*wdt+wh+1,wdt,&ocolors);
	GrFramedBox(ww/4-1,wh/4-1,ww/4+ww+1,wh/4+wh+1,wdt,&icolors);

	GrSetClipBox(ww/4,wh/4,ww/4+ww,wh/4+wh);
	drawing(ww/4,wh/4,ww,wh,c,bg);
	getkey();

	GrClearScreen(0);
	GrSetContext(save);

	bx = -(bw/2) + 15*bw;
	by = -(bh/3) + 15*bh;

	GrFramedBox(bx+2*wdt,by+2*wdt,bx+bw-2*wdt-1,by+bh-2*wdt-1,2*wdt,&bcolors);

	for(ii = 0, by = -(bh/3); ii < 18; ii++) {
	    for(jj = 0, bx = -(bw/2); jj < 18; jj++) {
		if((ii != 15) || (jj != 15)) {
		    GrBitBlt(save,
			bx,by,
			save,
			-(bw/2) + 15*bw,
			-(bh/3) + 15*bh,
			-(bw/2) + 15*bw + bw - 1,
			-(bh/3) + 15*bh + bh - 1,
			GrWRITE
		    );
		}
		bx += bw;
	    }
	    by += bh;
	}

	GrFramedBox(ww/4-5*wdt-1,wh/4-5*wdt-1,ww/4+5*wdt+ww+1,wh/4+5*wdt+wh+1,wdt,&ocolors);
	GrFramedBox(ww/4-1,wh/4-1,ww/4+ww+1,wh/4+wh+1,wdt,&icolors);

	GrSetClipBox(ww/4,wh/4,ww/4+ww,wh/4+wh);
	drawing(ww/4,wh/4,ww,wh,c,bg);
	getkey();


	GrBitBlt(tile,
	    0,0,
	    save,
	    -(bw/2) + 15*bw,
	    -(bh/3) + 15*bh,
	    -(bw/2) + 15*bw + bw - 1,
	    -(bh/3) + 15*bh + bh - 1,
	    GrWRITE
	);
	GrSetContext(tile);
	GrFramedBox(2*wdt,2*wdt,bw-2*wdt-1,bh-2*wdt-1,2*wdt,&bcolors);

	GrClearScreen(0);
	GrSetContext(save);

	for(ii = 0,by = -(bh/3); ii < 18; ii++) {
	    for(jj = 0,bx = -(bw/2); jj < 18; jj++) {
		GrBitBlt(save,
		    bx,by,
		    tile,
		    0,0,
		    bw-1,bh-1,
		    GrWRITE
		);
		bx += bw;
	    }
	    by += bh;
	}

	GrFramedBox(ww/4-5*wdt-1,wh/4-5*wdt-1,ww/4+5*wdt+ww+1,wh/4+5*wdt+wh+1,wdt,&ocolors);
	GrFramedBox(ww/4-1,wh/4-1,ww/4+ww+1,wh/4+wh+1,wdt,&icolors);

	GrSetClipBox(ww/4,wh/4,ww/4+ww,wh/4+wh);
	drawing(ww/4,wh/4,ww,wh,c,bg);

	getkey();
	GrResetClipBox();
	GrBitBlt(NULL,
	   60,60,
	   NULL,
	   20,20,
	   GrSizeX() - 40,
	   GrSizeY() - 40,
	   GrWRITE
	);

	getkey();

	GrBitBlt(NULL,
	   10,10,
	   NULL,
	   60,60,
	   GrSizeX() - 40,
	   GrSizeY() - 40,
	   GrWRITE
	);

	getkey();

	GrSetContext(tile);
	GrClearContext(0);

	GrBitBlt(tile,
	    0,0,
	    save,
	    -(bw/2),
	    -(bh/3),
	    -(bw/2) + 15*bw + bw - 1,
	    -(bh/3) + 15*bh + bh - 1,
	    GrWRITE
	);

	GrSetContext(save);
	GrClearScreen(0);

	for(ii = 0,by = -(bh/3); ii < 18; ii++) {
	    for(jj = 0,bx = -(bw/2); jj < 18; jj++) {
		GrBitBlt(save,
		    bx,by,
		    tile,
		    0,0,
		    bw-1,bh-1,
		    GrWRITE
		);
		bx += bw;
	    }
	    by += bh;
	}

	GrFramedBox(ww/4-5*wdt-1,wh/4-5*wdt-1,ww/4+5*wdt+ww+1,wh/4+5*wdt+wh+1,wdt,&ocolors);
	GrFramedBox(ww/4-1,wh/4-1,ww/4+ww+1,wh/4+wh+1,wdt,&icolors);

	GrSetClipBox(ww/4,wh/4,ww/4+ww,wh/4+wh);
	drawing(ww/4,wh/4,ww,wh,c,bg);

	getkey();

}

