/**
 ** WORDDRAW.H
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#ifndef _WORDDRAW_H_
#define _WORDDRAW_H_

#ifndef __GNUC__
#error  This file is for the DJGPP version only !!!
#endif

/*
 * utilities -- other files may define them too
 */
#ifndef _SaveDS

#define _ASV		asm volatile
#define _ClrDir()	_ASV("cld")
#define _SetDir()	_ASV("std")
#define _SaveDS()
#define _RestoreDS()

#endif  /* _SaveDS */

/*
 * display a bit mapped font character (both FGC and BGC)
 */
#define __WRTFONT__(dst,offs,bits,wdt,hgt,fg,bg,putword) do {		\
    int _HGT_ = (hgt);							\
    _ASV("                                                            \n\
	movl	%1,%%edi					      \n\
	movl	%3,%%esi					      \n\
	movl	%5,%%edx					      \n\
	xorl	%6,%%edx					      \n\
L_Font"#putword"NextRow:					      \n\
	movl	%4,%%ecx					      \n\
L_Font"#putword"ReadBits:					      \n\
	lodsb							      \n\
	movb	%%al,%%bl					      \n\
	stc							      \n\
	adcb	%%bl,%%bl					      \n\
L_Font"#putword"Loop:						      \n\
	sbbl	%%eax,%%eax					      \n\
	andl	%%edx,%%eax					      \n\
	xorl	%6,%%eax					      \n\
	"putword"						      \n\
	addb	%%bl,%%bl					      \n\
	loopnz  L_Font"#putword"Loop				      \n\
	orl	%%ecx,%%ecx					      \n\
	jnz	L_Font"#putword"ReadBits			      \n\
	addl	%2,%%edi					      \n\
	decl	%0						      \n\
	jnz	L_Font"#putword"NextRow				       "\
	: "=g" (_HGT_)							\
	: "g" (dst), "g" (offs),   "g" (bits),				\
	  "g" (wdt), "g" (fg),	   "g" (bg)				\
	: "di", "si", "dx", "cx", "bx", "ax"				\
    );									\
} while(0)

/*
 * display a bit mapped font character (FGC or BGC only)
 */
#define __WR1CFNT__(dst,offs,bits,wdt,hgt,color,jump,opr)     _ASV("  \n\
	movl	%0,%%edi					      \n\
	movl	%2,%%esi					      \n\
	movl	%4,%%ebx					      \n\
	movl	%5,%%edx					      \n\
L_Font"jump opr"NextRow:					      \n\
	movl	%3,%%ecx					      \n\
L_Font"jump opr"ReadBits:					      \n\
	lodsb							      \n\
	stc							      \n\
	adcb	%%al,%%al					      \n\
L_Font"jump opr"Loop:						      \n\
	"jump"  L_Font"jump opr"NoSet				      \n\
	"opr"w  %%dx,(%%edi)					      \n\
L_Font"jump opr"NoSet:						      \n\
	leal	2(%%edi),%%edi					      \n\
	addb	%%al,%%al					      \n\
	loopnz  L_Font"jump opr"Loop				      \n\
	orl	%%ecx,%%ecx					      \n\
	jnz	L_Font"jump opr"ReadBits			      \n\
	addl	%1,%%edi					      \n\
	decl	%%ebx						      \n\
	jnz	L_Font"jump opr"NextRow				       "\
	: /* NOTHING */							\
	: "g" (dst), "g" (offs), "g" (bits),				\
	  "g" (wdt), "g" (hgt),  "g" (color)				\
	: "di", "si", "dx", "cx", "bx", "ax"				\
)

#define __WFSET__	"stosw"
#define __WFXOR__	"xorw   %%ax,(%%edi); leal  2(%%edi),%%edi"
#define __WFOR__	"orw    %%ax,(%%edi); leal  2(%%edi),%%edi"
#define __WFAND__	"andw   %%ax,(%%edi); leal  2(%%edi),%%edi"

#define _WriteFont(dp,o,bp,w,h,f,b)	__WRTFONT__(dp,o,bp,w,h,f,b,__WFSET__)
#define _WriteFontXor(dp,o,bp,w,h,f,b)  __WRTFONT__(dp,o,bp,w,h,f,b,__WFXOR__)
#define _WriteFontOr(dp,o,bp,w,h,f,b)	__WRTFONT__(dp,o,bp,w,h,f,b,__WFOR__)
#define _WriteFontAnd(dp,o,bp,w,h,f,b)  __WRTFONT__(dp,o,bp,w,h,f,b,__WFAND__)

#define _WrFGCFont(dp,o,bp,w,h,fg)	__WR1CFNT__(dp,o,bp,w,h,fg,"jnc","mov")
#define _WrFGCFontXor(dp,o,bp,w,h,fg)	__WR1CFNT__(dp,o,bp,w,h,fg,"jnc","xor")
#define _WrFGCFontOr(dp,o,bp,w,h,fg)	__WR1CFNT__(dp,o,bp,w,h,fg,"jnc","or")
#define _WrFGCFontAnd(dp,o,bp,w,h,fg)	__WR1CFNT__(dp,o,bp,w,h,fg,"jnc","and")

#define _WrBGCFont(dp,o,bp,w,h,bg)	__WR1CFNT__(dp,o,bp,w,h,bg,"jc","mov")
#define _WrBGCFontXor(dp,o,bp,w,h,bg)	__WR1CFNT__(dp,o,bp,w,h,bg,"jc","xor")
#define _WrBGCFontOr(dp,o,bp,w,h,bg)	__WR1CFNT__(dp,o,bp,w,h,bg,"jc","or")
#define _WrBGCFontAnd(dp,o,bp,w,h,bg)	__WR1CFNT__(dp,o,bp,w,h,bg,"jc","and")

/*
 * set a bitmap patterned row
 */
#define __PTNROW__(dst,maskpatt,width,fgc,bgc,putword) _ASV("         \n\
	movl	%0,%%edi					      \n\
	movl	%1,%%edx					      \n\
	movl	%2,%%ecx					      \n\
	movl	%3,%%ebx					      \n\
	movl	%4,%%esi					      \n\
	xorl	%%esi,%%ebx					      \n\
L_Patt"#putword"Loop:						      \n\
	rolb	$1,%%dl						      \n\
	sbbl	%%eax,%%eax					      \n\
	andl	%%ebx,%%eax					      \n\
	xorl	%%esi,%%eax					      \n\
	"putword"						      \n\
	loop	L_Patt"#putword"Loop				       "\
	: /* NOTHING */							\
	: "g" (dst), "g" (maskpatt), "g" (width), "g" (fgc), "g" (bgc)  \
	: "di", "si", "dx", "cx", "bx", "ax"				\
)

/*
 * set a bitmap patterned row, foreground or background only
 */
#define __P1CROW__(dst,maskpatt,width,color,jump,opr) _ASV("          \n\
	movl	%0,%%edi					      \n\
	movl	%1,%%edx					      \n\
	movl	%2,%%ecx					      \n\
	movl	%3,%%eax					      \n\
L_Patt"jump opr"Loop:						      \n\
	rolb	$1,%%dl						      \n\
	"jump"  L_Patt"jump opr"NoSet				      \n\
	"opr"w  %%ax,(%%edi)					      \n\
L_Patt"jump opr"NoSet:						      \n\
	leal	2(%%edi),%%edi					      \n\
	loop	L_Patt"jump opr"Loop				      \n\
L_Patt"jump opr"End:						       "\
	: /* NOTHING */							\
	: "g" (dst), "g" (maskpatt), "g" (width), "g" (color)		\
	: "di", "dx", "cx", "ax"					\
)

#define _PatternSet(dst,msk,wdt,f,b)	__PTNROW__(dst,msk,wdt,f,b,__WFSET__)
#define _PatternXor(dst,msk,wdt,f,b)	__PTNROW__(dst,msk,wdt,f,b,__WFXOR__)
#define _PatternOr(dst,msk,wdt,f,b)	__PTNROW__(dst,msk,wdt,f,b,__WFOR__)
#define _PatternAnd(dst,msk,wdt,f,b)	__PTNROW__(dst,msk,wdt,f,b,__WFAND__)

#define _PattFGCSet(dst,msk,wdt,fg)	__P1CROW__(dst,msk,wdt,fg,"jnc","mov")
#define _PattFGCXor(dst,msk,wdt,fg)	__P1CROW__(dst,msk,wdt,fg,"jnc","xor")
#define _PattFGCOr(dst,msk,wdt,fg)	__P1CROW__(dst,msk,wdt,fg,"jnc","or")
#define _PattFGCAnd(dst,msk,wdt,fg)	__P1CROW__(dst,msk,wdt,fg,"jnc","and")

#define _PattBGCSet(dst,msk,wdt,bg)	__P1CROW__(dst,msk,wdt,bg,"jc","mov")
#define _PattBGCXor(dst,msk,wdt,bg)	__P1CROW__(dst,msk,wdt,bg,"jc","xor")
#define _PattBGCOr(dst,msk,wdt,bg)	__P1CROW__(dst,msk,wdt,bg,"jc","or")
#define _PattBGCAnd(dst,msk,wdt,bg)	__P1CROW__(dst,msk,wdt,bg,"jc","and")

/*
 * X major line drawing
 */
#define __XLINE__(dst,offs,deltx,delty,color,putword) _ASV("          \n\
	movl	%0,%%edi					      \n\
	movl	%1,%%esi					      \n\
	movl	%2,%%ecx					      \n\
	movl	%3,%%ebx					      \n\
	movl	%4,%%eax					      \n\
	movl	%%ecx,%%edx					      \n\
	shrl	$1,%%edx					      \n\
	incl	%%ecx						      \n\
L_LineX"#putword"Loop:						      \n\
	"putword"						      \n\
	subl	%%ebx,%%edx					      \n\
	jnc	L_LineX"#putword"NoAdjust			      \n\
	addl	%2,%%edx					      \n\
	addl	%%esi,%%edi					      \n\
L_LineX"#putword"NoAdjust:					      \n\
	loop	L_LineX"#putword"Loop				       "\
	: /* NOTHING */							\
	: "g" (dst), "g" (offs), "g" (deltx), "g" (delty), "g" (color)  \
	: "di", "si", "dx", "cx", "bx", "ax"				\
)

#define __XLSET__	"stosw"
#define __XLXOR__	"xorw   %%ax,(%%edi); leal  2(%%edi),%%edi"
#define __XLOR__	"orw    %%ax,(%%edi); leal  2(%%edi),%%edi"
#define __XLAND__	"andw   %%ax,(%%edi); leal  2(%%edi),%%edi"

#define _DrawXLine(dp,do,dx,dy,c)	__XLINE__(dp,do,dx,dy,c,__XLSET__)
#define _DrawXLineXor(dp,do,dx,dy,c)	__XLINE__(dp,do,dx,dy,c,__XLXOR__)
#define _DrawXLineOr(dp,do,dx,dy,c)	__XLINE__(dp,do,dx,dy,c,__XLOR__)
#define _DrawXLineAnd(dp,do,dx,dy,c)	__XLINE__(dp,do,dx,dy,c,__XLAND__)

/*
 * Y major line drawing
 */
#define __YLINE__(dst,offs,deltx,delty,color,putword) _ASV("          \n\
	movl	%0,%%edi					      \n\
	movl	%1,%%esi					      \n\
	movl	%3,%%ecx					      \n\
	movl	%2,%%ebx					      \n\
	movl	%4,%%eax					      \n\
	movl	%%ecx,%%edx					      \n\
	shrl	$1,%%edx					      \n\
	incl	%%ecx						      \n\
L_LineY"#putword"Loop:						      \n\
	"putword"						      \n\
	addl	%%esi,%%edi					      \n\
	subl	%%ebx,%%edx					      \n\
	jnc	L_LineY"#putword"NoAdjust			      \n\
	addl	%3,%%edx					      \n\
	leal	2(%%edi),%%edi					      \n\
L_LineY"#putword"NoAdjust:					      \n\
	loop	L_LineY"#putword"Loop				       "\
	: /* NOTHING */							\
	: "g" (dst), "g" (offs), "g" (deltx), "g" (delty), "g" (color)  \
	: "di", "si", "dx", "cx", "bx", "ax"				\
)

#define __YLSET__	"movw   %%ax,(%%edi)"
#define __YLXOR__	"xorw   %%ax,(%%edi)"
#define __YLOR__	"orw    %%ax,(%%edi)"
#define __YLAND__	"andw   %%ax,(%%edi)"

#define _DrawYLine(dp,do,dx,dy,c)	__YLINE__(dp,do,dx,dy,c,__YLSET__)
#define _DrawYLineXor(dp,do,dx,dy,c)	__YLINE__(dp,do,dx,dy,c,__YLXOR__)
#define _DrawYLineOr(dp,do,dx,dy,c)	__YLINE__(dp,do,dx,dy,c,__YLOR__)
#define _DrawYLineAnd(dp,do,dx,dy,c)	__YLINE__(dp,do,dx,dy,c,__YLAND__)

#endif  /* whole file */

