/**
 ** VGAREGS.H
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

/*
 * color plane operations
 */
#define VGA_FUNC_SET	0
#define VGA_FUNC_AND	8
#define VGA_FUNC_OR	16
#define VGA_FUNC_XOR	24

/*
 * Sequencer port and used register indices
 */
#define VGA_SEQUENCER_PORT	0x3c4
#define VGA_SEQUENCER_DATA	0x3c5

#define VGA_WRT_PLANE_ENB_REG	2

/*
 * Graphics controller port and used registers
 */
#define VGA_GR_CTRL_PORT	0x3ce
#define VGA_GR_CTRL_DATA	0x3cf

#define VGA_SET_RESET_REG	0
#define VGA_SET_RESET_ENB_REG	1
#define VGA_COLOR_COMP_REG	2
#define VGA_ROT_FN_SEL_REG	3
#define VGA_RD_PLANE_SEL_REG	4
#define VGA_MODE_REG		5
#define VGA_MISC_REG		6
#define VGA_COLOR_DONTC_REG	7
#define VGA_BIT_MASK_REG	8

/*
 * these are used from inline assembly...
 */
#ifdef __GNUC__
  asm("L_VGA_GR_CTRL_PORT = 0x3ce");
  asm("L_VGA_BIT_MASK_REG = 8");
  asm("L_VGA_MODE_REG     = 5");
#endif

/*
 * set a VGA register
 */
#ifdef __GNUC__
#define __SET_VGA_REG__(port,reg,value) asm volatile(		     "\n\
	movl	%0,%%eax					      \n\
	movl	%1,%%edx					      \n\
	outw	%%ax,%%dx					       "\
	: /* NOTHING */							\
	: "g" (((value) << 8) | (reg)), "g" (port)			\
	: "dx", "ax"							\
)
#endif  /* __GNUC__ */

#ifdef  __TURBOC__
#define __SET_VGA_REG__(port,reg,value) do {				\
    _AX = ((value) << 8) | (reg);					\
    _DX = (port);							\
    asm out dx,ax;							\
} while(0)
#endif  /* __TURBOC__ */

/*
 * read a VGA register
 */
#ifdef __GNUC__
#define __READ_VGA_REG__(port,reg,value) asm volatile(		     "\n\
	movl	%1,%%eax					      \n\
	movl	%2,%%edx					      \n\
	outb	%%al,%%dx					      \n\
	incl	%%edx						      \n\
	inb	%%dx,%%al					      \n\
	andl	$0x000000ff,%%eax				      \n\
	movl	%%eax,%0					       "\
	: "=g" (value)							\
	: "g" (reg), "g" (port)						\
	: "dx", "ax"							\
)
#endif  /* __GNUC__ */

#ifdef  __TURBOC__
#define __READ_VGA_REG__(port,reg,value) do {				\
    _AX = (reg);							\
    _DX = (port);							\
    asm out dx,al;							\
    asm inc dx;								\
    asm in  al,dx;							\
    asm xor ah,ah;							\
    (value) = _AX;							\
} while(0)
#endif  /* __TURBOC__ */

/*
 * Simple register settings
 */
#define _SetVGAWriteMode(mode) \
    __SET_VGA_REG__(VGA_GR_CTRL_PORT,_GrP4ModeReg,mode)

#define _SetVGAWritePlane(plane) \
    __SET_VGA_REG__(VGA_SEQUENCER_PORT,VGA_WRT_PLANE_ENB_REG,(1 << (plane)))

#define _SetVGAPlaneMask(mask) \
    __SET_VGA_REG__(VGA_SEQUENCER_PORT,VGA_WRT_PLANE_ENB_REG,(mask))

#define _SetVGAWriteAllPlanes() \
    __SET_VGA_REG__(VGA_SEQUENCER_PORT,VGA_WRT_PLANE_ENB_REG,0x0f);

#define _SetVGAReadPlane(plane) \
    __SET_VGA_REG__(VGA_GR_CTRL_PORT,VGA_RD_PLANE_SEL_REG,plane)

#define _SetVGASetResetPlanes(planes) \
    __SET_VGA_REG__(VGA_GR_CTRL_PORT,VGA_SET_RESET_ENB_REG,planes)

#define _SetVGAColorFunction(func) \
    __SET_VGA_REG__(VGA_GR_CTRL_PORT,VGA_ROT_FN_SEL_REG,func)

#define _SetVGAFillData(color) \
    __SET_VGA_REG__(VGA_GR_CTRL_PORT,VGA_SET_RESET_REG,color)

#define _SetVGADontCareRegister(value) \
    __SET_VGA_REG__(VGA_GR_CTRL_PORT,VGA_COLOR_DONTC_REG,value)

#define _SetVGAWriteMask(mask) \
    __SET_VGA_REG__(VGA_GR_CTRL_PORT,VGA_BIT_MASK_REG,mask)

/*
 * Somewhat more complex register settings
 */
#define _SetVideoColorOper(oper) \
    __SET_VGA_REG__(VGA_GR_CTRL_PORT,_GrP4WriteOps[oper],0)

#define _SetVideoColor(color,oper) do {					\
    _SetVideoColorOper(oper);						\
    _SetVGAFillData(color);						\
} while(0)

