/**
 ** THICKLNE.H
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

typedef struct {
    GrLineOption opt;			/* the on-off pattern */
    void *fillarg;			/* the fill argument */
    int  total_pattlen;			/* total length of the pattern */
    int  cursect_left;			/* how many pixels left in the current section */
    int  next_sect;			/* the index of the next section to use */
    int  drawn_sect;			/* is this a drawn section */
    _GrPixelDrawProc pixelproc;		/* pixel fill routine for wide polygon fill */
    _GrLineDrawProc  borderproc;	/* border draw routine for wide polygon fill */
    _GrScanLineProc  scanfillproc;	/* scan line fill routine for wide polygon fill */
    int  is_XOR_color;			/* flag for XOR mode fills and draws */
} GrCustomLineData;

extern void _GrBuildCustomLineData(GrLineOption *op,GrCustomLineData *where);
extern void _GrSetupSolidDraw(int *color,GrCustomLineData *where);
extern void _GrSetupPatternedDraw(GrPattern *pat,GrCustomLineData *where);
extern void _GrDoCustomSegment(int x1,int y1,int x2,int y2,void *arg);
extern void _GrDoSingleCustomSegment(int x1,int y1,int x2,int y2,GrCustomLineData *arg);
extern void _GrDoCustomCorner(int x,int y,void *arg);


