/**
 ** SWPIXCOL.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"

#define PROTO	long,int,int
extern  void	_GrVoidDriver(PROTO);

static void (*setpixcolumntab[])(PROTO) = {
    _GrVoidDriver,
    USE_DRIVER_1(_GrP1SetPixColumn),
    USE_DRIVER_4(_GrP4SetPixColumn),
    USE_DRIVER_8(_GrP8SetPixColumn),
    USE_DRIVER_H(_GrPHSetPixColumn),
    USE_DRIVER_X(_GrPXSetPixColumn),
    USE_DRIVER_I(_GrPISetPixColumn),
    USE_DRIVER_S(_GrPSSetPixColumn),
    USE_DRIVER_M16(_GrM16SetPixColumn)
};

static void setpixcolumn(long addr,int color,int height)
{
	_GrSetPixColumn = setpixcolumntab[_GrDriverIndex];
	_GrResetValues[SetPixColumnIndex] = (handler)setpixcolumn;
	_GrResetAddresses[SetPixColumnIndex] = (handler *)(&_GrSetPixColumn);
	(*_GrSetPixColumn)(addr,color,height);
}

void (*_GrSetPixColumn)(PROTO) = setpixcolumn;

