/**
 ** SWFILLP.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"

#define PROTO	int,int,int,GrPattern *
extern  void	_GrVoidDriver(PROTO);

static void (*fillpatterntab[])(PROTO) = {
    _GrVoidDriver,
    USE_DRIVER_1(_GrP1FillPattern),
    USE_DRIVER_4(_GrP4FillPattern),
    USE_DRIVER_8(_GrP8FillPattern),
    USE_DRIVER_H(_GrPHFillPattern),
    USE_DRIVER_X(_GrPXFillPattern),
    USE_DRIVER_I(_GrPIFillPattern),
    USE_DRIVER_S(_GrPSFillPattern),
    USE_DRIVER_M16(_GrM16FillPattern)
};

static void fillpattern(int x,int y,int width,GrPattern *p)
{
	_GrFillPattern = fillpatterntab[_GrDriverIndex];
	_GrResetValues[FillPatternIndex] = (handler)fillpattern;
	_GrResetAddresses[FillPatternIndex] = (handler *)(&_GrFillPattern);
	(*_GrFillPattern)(x,y,width,p);
}

void (*_GrFillPattern)(PROTO) = fillpattern;

