/**
 ** SCANELLP.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "clipping.h"

#ifdef __TURBOC__
#define  MAX_R_SQUARE	120
#endif

#ifdef __GNUC__
#define  MAX_R_SQUARE	32000
#endif

void _GrScanEllipse(
    int xc,int yc,int xa,int ya,
    int filled,
    int is_XOR_color,
    _GrPixelDrawProc pixelproc,
    _GrLineDrawProc  borderproc,
    _GrScanLineProc  scanfillproc,
    void *fillarg)
{
	int x1,x2,y1,y2;
	MOUSE_FLAG;

	if(xa < 0) xa = (-xa);
	if(ya < 0) ya = (-ya);
	x1 = xc - xa; y1 = yc - ya;
	x2 = xc + xa; y2 = yc + ya;
	CLIPSORTEDBOX(CURC,x1,y1,x2,y2);
	MOUSE_BLOCK(CURC,x1,y1,x2,y2);
	if(ya == 0) {
	    if(xa == 0) (*pixelproc)(xc,yc,fillarg);
	    else	(*scanfillproc)(x1,x2,yc,fillarg);
	}
	else if(xa == 0) {
	    (*borderproc)(xc,y1,xc,y2,fillarg);
	}
	else if(xa > (MAX_R_SQUARE / ya)) {	/* Bresenheim would overflow !! */
	    int points[MAX_ELLIPSE_PTS+1][2];
	    int numpts = _GrGenerateEllipse(points,xc,yc,xa,ya);
	    if(filled) _GrScanConvexPoly(numpts,points,
		is_XOR_color,
		pixelproc,
		borderproc,
		scanfillproc,
		fillarg
	    );
	    else _GrDrawPolygon(numpts,points,
		TRUE,
		is_XOR_color,
		pixelproc,
		borderproc,
		fillarg
	    );
	}
	else {
	    int yasq  = ya * ya;
	    int xasq  = xa * xa;
	    int xasq2 = xasq << 1;
	    int yasq2 = yasq << 1;
	    int xasq4 = xasq << 2;
	    int yasq4 = yasq << 2;
	    int row   = ya;
	    int col   = 0;
	    int DST   = (xasq2 * (row - 1) * row) + xasq + (yasq2 * (1 - xasq));
	    while((xasq * row) > (yasq * col)) {
		if(!filled) {
		    (*pixelproc)(xc-col,yc-row,fillarg);
		    (*pixelproc)(xc-col,yc+row,fillarg);
		    if(col) {
			(*pixelproc)(xc+col,yc-row,fillarg);
			(*pixelproc)(xc+col,yc+row,fillarg);
		    }
		}
		if(DST >= 0) {
		    if(filled) {
			(*scanfillproc)(xc-col,xc+col,yc-row,fillarg);
			(*scanfillproc)(xc-col,xc+col,yc+row,fillarg);
		    }
		    row--;
		    DST -= xasq4 * row;
		}
		DST += yasq2 * (3 + (col << 1));
		col++;
	    }
	    DST = (yasq2 * (col + 1) * col) + (xasq2 * (row * (row - 2) + 1)) + ((1 - xasq2) * yasq);
	    while(row >= 0) {
		if(!filled) {
		    (*pixelproc)(xc-col,yc-row,fillarg);
		    (*pixelproc)(xc+col,yc-row,fillarg);
		    if(row) {
			(*pixelproc)(xc-col,yc+row,fillarg);
			(*pixelproc)(xc+col,yc+row,fillarg);
		    }
		}
		else {
		    (*scanfillproc)(xc-col,xc+col,yc-row,fillarg);
		    if(row) (*scanfillproc)(xc-col,xc+col,yc+row,fillarg);
		}
		if(DST <= 0) {
		    col++;
		    DST += yasq4 * col;
		}
		row--;
		DST += xasq2 * (2 - (row << 1));
	    }
	}
	MOUSE_UNBLOCK();
}

