/** 
 ** RESLIST.C 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "grxfile.h"
#include "gmalloc.h"

#include <string.h>


void _GrAddToResList(void *data,char *name,ResList **list)
{
	ResList *p = _GrMalloc(sizeof(ResList) + strlen(name) + 1);

	if(p != NULL) {
	    strcpy(p->name,name);
	    p->data = data;
	    p->next = *list;
	    *list = p;
	}
}

void _GrRemoveFromResList(void *data,ResList **list)
{
	ResList *this = *list;
	ResList *prev = NULL;

	while(this != NULL) {
	    if(this->data == data) {
		*(prev ? &prev->next : list) = this->next;
		_GrFree(this);
		return;
	    }
	    prev = this;
	    this = this->next;
	}
}

void *_GrLookupInResList(char *name,ResList *list)
{
	while(list != NULL) {
	    if(strcmp(list->name,name) == 0)
		return(list->data);
	    list = list->next;
	}
	return(NULL);
}


