/**
 ** POLYGON.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"

void _GrDrawPolygon(int n,int pt[][2],
    int do_close,
    int is_XOR_color,
    _GrPixelDrawProc cornerproc,
    _GrLineDrawProc  lineproc,
    void *fillarg)
{
	int ii;
	MOUSE_FLAG;

	MOUSE_BLOCK(CURC,_GrLoX,_GrLoY,_GrHiX,_GrHiY);
	if((n <= 2) ||
	   ((do_close != FALSE) &&
	    (pt[0][0] == pt[n-1][0]) &&
	    (pt[0][1] == pt[n-1][1]) &&
	    (--n == 2))) {
	    if(n <= 1) {
		if(n > 0) (*cornerproc)(pt[0][0],pt[0][1],fillarg);
		MOUSE_UNBLOCK();
		return;
	    }
	    (*lineproc)(pt[0][0],pt[0][1],pt[1][0],pt[1][1],fillarg);
	    MOUSE_UNBLOCK();
	    return;
	}
	for(ii = 0; ii < (n - 1); ii++) {
	    (*lineproc)(pt[ii][0],pt[ii][1],pt[ii+1][0],pt[ii+1][1],fillarg);
	    if((ii > 0) && is_XOR_color) (*cornerproc)(pt[ii][0],pt[ii][1],fillarg);
	}
	if(do_close) {
	    (*lineproc)(pt[ii][0],pt[ii][1],pt[0][0],pt[0][1],fillarg);
	    if(is_XOR_color) {
		(*cornerproc)(pt[ii][0],pt[ii][1],fillarg);
		(*cornerproc)(pt[0][0],pt[0][1],fillarg);
	    }
	}
	MOUSE_UNBLOCK();
}

