/**
 ** PILINE.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p8514a.h"

void _GrPIDrawLine(long addr,int color,int deltax,int deltay)
{

	if(CURC->gc_onscreen) {
	    int oper = C_OPER(color);
	    int command = CMD_LINE | DRAW | PLANAR | WRTDATA | INC_X | INC_Y;
	    int majorAxis,minorAxis;
	    int twiceMinor;
	    if((_GrPIDrawTable[oper] ^ (color &= C_SIGNIF)) == 0) return;
	    WaitQueue(4);
	    outpw(FRGD_COLOR,color);
	    outpw(FRGD_MIX,_GrPIMixTable[oper]);
	    outpw(CUR_X,COORD_X(addr));
	    outpw(CUR_Y,COORD_Y(addr));
	    if(deltay < 0) {
		deltay = (-deltay);
		command &= ~INC_Y;
	    }
	    if(deltax < deltay) {
		command |= YMAJAXIS;
		majorAxis = deltay;
		minorAxis = deltax;
	    }
	    else {
		majorAxis = deltax;
		minorAxis = deltay;
	    }
	    twiceMinor = minorAxis << 1;
	    WaitQueue(5);
	    outpw(ERR_TERM,twiceMinor - majorAxis - 1);
	    outpw(DESTY_AXSTP,twiceMinor);
	    outpw(DESTX_DIASTP,(twiceMinor - (majorAxis << 1)));
	    outpw(MAJ_AXIS_PCNT,majorAxis);
	    outpw(CMD,command);
	    return;
	}
	_GrP8DrawLine(addr,color,deltax,deltay);
}

