/**
 ** PIINIT.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p8514a.h"

/*
 * An element of this table gets XOR-ed with the significant bits of
 * the color. It has to be drawn only if the result is nonzero
 */
int _GrPIDrawTable[4] = {
    ~C_SIGNIF,		/* C_SET -- always draw */
    0,			/* C_XOR -- draw only if non-zero */
    0,			/* C_OR  -- draw only if non-zero */
    C_SIGNIF		/* C_AND -- draw only if not all 1-s */
};

int _GrPIMixTable[4] = {
    FSS_FRGDCOL | MIX_SRC,	      /* C_SET */
    FSS_FRGDCOL | MIX_XOR,	      /* C_XOR */
    FSS_FRGDCOL | MIX_OR,	      /* C_OR  */
    FSS_FRGDCOL | MIX_AND	      /* C_AND */
};

