/**
 ** PHCHAR.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p16.h"
#include "worddraw.h"

void _GrPHDrawChar(long a,int w,int h,char far *bits,int fg,int bg)
{
	pixptr p = P_ADDRESS(CURC,a);
	int skip = CURC->gc_lineoffset - (w << 1);
	int fgop = C_OPER(fg);
	int bgop = C_OPER(bg);
	int drawfg = _GrPHDrawTable[fgop] ^ (fg &= C_SIGNIF);
	int drawbg = _GrPHDrawTable[bgop] ^ (bg &= C_SIGNIF);

	if((w <= 0) || (h <= 0)) return;
	_ClrDir();
	_SaveDS();
	if(drawfg && drawbg && (fgop == bgop)) {
	    switch(fgop) {
		case C_XOR: _WriteFontXor(p,skip,bits,w,h,fg,bg); break;
		case C_OR:  _WriteFontOr(p,skip,bits,w,h,fg,bg);  break;
		case C_AND: _WriteFontAnd(p,skip,bits,w,h,fg,bg); break;
		default:    _WriteFont(p,skip,bits,w,h,fg,bg);	  break;
	    }
	}
	else {
	    if(drawfg) switch(fgop) {
		case C_XOR: _WrFGCFontXor(p,skip,bits,w,h,fg); break;
		case C_OR:  _WrFGCFontOr(p,skip,bits,w,h,fg);  break;
		case C_AND: _WrFGCFontAnd(p,skip,bits,w,h,fg); break;
		default:    _WrFGCFont(p,skip,bits,w,h,fg);    break;
	    }
	    if(drawbg) switch(bgop) {
		case C_XOR: _WrBGCFontXor(p,skip,bits,w,h,bg); break;
		case C_OR:  _WrBGCFontOr(p,skip,bits,w,h,bg);  break;
		case C_AND: _WrBGCFontAnd(p,skip,bits,w,h,bg); break;
		default:    _WrBGCFont(p,skip,bits,w,h,bg);    break;
	    }
	}
	_RestoreDS();
}

