/**
 ** PHBITBLT.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p16.h"
#include "memcopy.h"
#include "gmalloc.h"

void _GrPHPixCopy(GC *dst,long daddr,GC *src,long saddr,int w,int h,int op)
{
	pixptr dstp = P_ADDRESS(dst,daddr);
	pixptr srcp = P_ADDRESS(src,saddr);
	pixptr temp;
	int wbytes = (w << 1);
	int doff = dst->gc_lineoffset - wbytes;
	int soff = src->gc_lineoffset - wbytes;
	int reverse = FALSE;

	if((w <= 0) || (h <= 0)) return;
	op = C_OPER(op);
	_ClrDir();
	if((dst->gc_baseaddr == src->gc_baseaddr) && (daddr > saddr)) {
	    dstp = (pixptr)((long)dstp + (h * dst->gc_lineoffset) - doff - 2);
	    srcp = (pixptr)((long)srcp + (h * src->gc_lineoffset) - soff - 2);
	    doff = (-doff);
	    soff = (-soff);
	    reverse = TRUE;
	    _SetDir();
	}
	if(dst->gc_onscreen && src->gc_onscreen && _GrBigFrameBuffer) {
	    if(_GrCanBcopyInBlit && (op == C_SET)) {
		dstp = (pixptr)((long)dstp + _GrWrOnlyOffset);
		srcp = (pixptr)((long)srcp + _GrRdOnlyOffset);
	    }
	    else {
		temp = (pixptr)_GrGetTempBuffer(wbytes + 2);
		if(temp == (pixptr)NULL) return;
		if(reverse) { temp += w; wbytes = (-wbytes); }
		doff += wbytes;
		soff += wbytes;
		_SaveDS();
		while(--h >= 0) {
		    _RowCpyW(RB,temp,srcp,w);
		    switch(op) {
			case C_XOR: _RowCpyXorW(WBX,dstp,temp,w); break;
			case C_OR:  _RowCpyOrW(WBO,dstp,temp,w);  break;
			case C_AND: _RowCpyAndW(WBA,dstp,temp,w); break;
			default:    _RowCpyW(WB,dstp,temp,w);	  break;
		    }
		    dstp = (pixptr)((long)dstp + doff);
		    srcp = (pixptr)((long)srcp + soff);
		}
		_RestoreDS();
		_ClrDir();
		return;
	    }
	}
	_SaveDS();
	switch(op) {
	    case C_XOR: _BlkCpyXorW(CWX,dstp,doff,srcp,soff,w,h); break;
	    case C_OR:  _BlkCpyOrW(CWO,dstp,doff,srcp,soff,w,h);  break;
	    case C_AND: _BlkCpyAndW(CWA,dstp,doff,srcp,soff,w,h); break;
	    default:	_BlkCpyW(CW,dstp,doff,srcp,soff,w,h);	  break;
	}
	_RestoreDS();
	_ClrDir();
}

