/**
 ** PATFCIRC.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "clipping.h"

void GrPatternFilledEllipse(int xc,int yc,int xa,int ya,GrPattern *p)
{
	_GrScanEllipse(xc,yc,xa,ya,
	    TRUE,
	    IS_XOR_PATTERN(p),
	    _GrDrawPatternedPixel,
	    _GrDrawPatternedLine,
	    _GrFillPatternedScanLine,
	    p
	);
}

void GrPatternFilledEllipseArc(int xc,int yc,int xa,int ya,int start,int end,GrPattern *p)
{
	int points[MAX_ELLIPSE_PTS+1][2];
	int numpts = _GrGenerateEllipseArc(points,xc,yc,xa,ya,start,end,TRUE);

	if(numpts < 0) _GrScanConvexPoly((-numpts),points,
	    IS_XOR_PATTERN(p),
	    _GrDrawPatternedPixel,
	    _GrDrawPatternedLine,
	    _GrFillPatternedScanLine,
	    p
	);
	else _GrScanPolygon(numpts,points,
	    IS_XOR_PATTERN(p),
	    _GrDrawPatternedPixel,
	    _GrDrawPatternedLine,
	    _GrFillPatternedScanLine,
	    p
	);
}

void GrPatternFilledCircle(int xc,int yc,int r,GrPattern *p)
{
	GrPatternFilledEllipse(xc,yc,r,r,p);
}


void GrPatternFilledCircleArc(int xc,int yc,int r,int start,int end,GrPattern *p)
{
	GrPatternFilledEllipseArc(xc,yc,r,r,start,end,p);
}

