/**
 ** PATFBOX.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "clipping.h"

void GrPatternFilledBox(int x1,int y1,int x2,int y2,GrPattern *p)
{
	int width,height;
	MOUSE_FLAG;

	CLIPBOX(CURC,x1,y1,x2,y2);
	MOUSE_BLOCK(CURC,x1,y1,x2,y2);
	width  = x2 - x1 + 1;
	height = y2 - y1 + 1;
	if(!p->gp_ispixmap)
	    while(--height >= 0) _GrFillPattern(x1,y1++,width,p);
	else {
	    int pwdt = p->gp_pxp_width;
	    int phgt = p->gp_pxp_height;
	    int xoff = (x1 + CURC->gc_xoffset) % pwdt;
	    int yoff = (y1 + CURC->gc_yoffset) % phgt;
	    while(height > 0) {
		int fillh   = MIN(height,(phgt - yoff));
		int linewdt = width;
		int xpos    = x1;
		int xcuroff = xoff;
		while(linewdt > 0) {
		    int fillw = MIN(linewdt,(pwdt - xcuroff));
		    _GrPixCopy(CURC,PIX_ADDR(CURC,xpos,y1),
			(GC *)(&p->gp_pxp_source),PIX_ADDR(&p->gp_pxp_source,xcuroff,yoff),
			fillw,fillh,p->gp_pxp_oper
		    );
		    linewdt -= fillw;
		    xpos += fillw;
		    xcuroff = 0;
		}
		height -= fillh;
		y1 += fillh;
		yoff = 0;
	    }
	}
	MOUSE_UNBLOCK();
}

