/**
 ** P8FILLP.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p8.h"
#include "memcopy.h"
#include "bytedraw.h"
#include "gmalloc.h"

void _GrP8FillPattern(int x,int y,int width,GrPattern *p)
{
	pixptr dst;

	if(width <= 0) return;
	if(_GrP8UsePlanarMode) PLANAR_MODE_OFF();
	x += CURC->gc_xoffset;
	y += CURC->gc_yoffset;
	dst = (pixptr)(CURC->gc_baseaddr + (y * CURC->gc_lineoffset) + x);
	_ClrDir();
	if(p->gp_ispixmap) {
	    int pattwdt = p->gp_pxp_width;
	    int optype  = C_OPER(p->gp_pxp_oper);
	    int cpysize = x % pattwdt;
	    pixptr srcline = (pixptr)(p->gp_pxp_source.gc_baseaddr +
		 ((y % p->gp_pxp_height) * p->gp_pxp_source.gc_lineoffset));
	    pixptr srcptr;

	    if(p->gp_pxp_source.gc_onscreen) {
		srcptr = (pixptr)_GrGetTempBuffer(pattwdt);
		if(srcptr == NULL) return;
		_SaveDS();
		_RowCpyB(GETPAT,srcptr,srcline,pattwdt);
		_RestoreDS();
		srcline = srcptr;
	    }
	    srcptr  = srcline + cpysize;
	    cpysize = pattwdt - cpysize;
	    _SaveDS();
	    while(width > 0) {
		if(cpysize > width) cpysize = width;
		switch(optype) {
		    case C_XOR: _RowCpyXorB(X,dst,srcptr,cpysize); break;
		    case C_OR:  _RowCpyOrB(O,dst,srcptr,cpysize);  break;
		    case C_AND: _RowCpyAndB(A,dst,srcptr,cpysize); break;
		    default:	_RowCpyB(C,dst,srcptr,cpysize);	   break;
		}
		width  -= cpysize;
		dst    += cpysize;
		srcptr  = srcline;
		cpysize = pattwdt;
	    }
	    _RestoreDS();
	}
	else {
	    int bits = p->gp_bmp_data[y % p->gp_bmp_height];
	    int fgc  = p->gp_bmp_fgcolor;
	    int bgc  = p->gp_bmp_bgcolor;
	    int fgop = C_OPER(fgc);
	    int bgop = C_OPER(bgc);
	    int drawfg = _GrP8DrawTable[fgop] ^ (fgc &= C_SIGNIF);
	    int drawbg = _GrP8DrawTable[bgop] ^ (bgc &= C_SIGNIF);

	    x &= 7;
	    bits = (bits << x) | ((bits & 0xff) >> (8 - x));
	    if(drawfg && drawbg && (fgop == bgop)) {
		bgc |= ((fgc ^ bgc) << 8);
		switch(fgop) {
		    case C_XOR: _PatternXor(dst,bits,width,bgc); return;
		    case C_OR:  _PatternOr(dst,bits,width,bgc);  return;
		    case C_AND: _PatternAnd(dst,bits,width,bgc); return;
		    default:	_PatternSet(dst,bits,width,bgc); return;
		}
	    }
	    if(drawfg) switch(fgop) {
		case C_XOR: _PattFGCXor(dst,bits,width,fgc); break;
		case C_OR:  _PattFGCOr(dst,bits,width,fgc);  break;
		case C_AND: _PattFGCAnd(dst,bits,width,fgc); break;
		default:    _PattFGCSet(dst,bits,width,fgc); break;
	    }
	    if(drawbg) switch(bgop) {
		case C_XOR: _PattBGCXor(dst,bits,width,bgc); break;
		case C_OR:  _PattBGCOr(dst,bits,width,bgc);  break;
		case C_AND: _PattBGCAnd(dst,bits,width,bgc); break;
		default:    _PattBGCSet(dst,bits,width,bgc); break;
	    }
	}
}

