/**
 ** P8.H
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#ifdef  __TURBOC__
#pragma inline
#endif

#include "grx.h"
#include "libgrx.h"
#include "vgaregs.h"

typedef unsigned char far *pixptr;	/* pixel pointer */
#define C_SIGNIF    0xff		/* significant bits in a color */
extern  int _GrP8DrawTable[];		/* drawing control table */

#ifdef _INLINE256
# define P_ADDRESS(cxt,off)  ((pixptr)(off))
# define P_XADDRESS(cxt,off) ((pixptr)((cxt)->gc_baseaddr +
     (((long)(off) - (long)((cxt)->gc_baseaddr)) >> 2)
))
#else
# define P_ADDRESS(cxt,off)  ((pixptr)((cxt)->gc_baseaddr +		\
     (unsigned)(COORD_Y(off) * (cxt)->gc_lineoffset) +			\
     (unsigned)(COORD_X(off))						\
))
# define P_XADDRESS(cxt,off)  ((pixptr)((cxt)->gc_baseaddr +		\
     ((unsigned)(COORD_Y(off) * (cxt)->gc_lineoffset) >> 2) +		\
     ((unsigned)(COORD_X(off)) >> 2)					\
))
#endif /* _INLINE256 */

extern  int  _GrP8Chain4Off;		/* turns off plane mode */
extern  int  _GrP8Chain4On;		/* turns on plane mode */
extern  char _GrP8UsePlanarMode;	/* set with well-behaved cards */
extern  char _GrP8PlanarModeOn;		/* plane mode status flag */
extern  int  _GrP8RmaskTable[];		/* right plane masks */
extern  int  _GrP8LmaskTable[];		/* left plane masks */

#define PLANAR_MODE_ON() do {						\
    if(!_GrP8PlanarModeOn) {						\
	__SET_VGA_REG__(VGA_SEQUENCER_PORT,_GrP8Chain4Off,0);		\
	_GrP8PlanarModeOn = TRUE;					\
    }									\
} while(0)

#define PLANAR_MODE_OFF() do {						\
    if(_GrP8PlanarModeOn) {						\
	__SET_VGA_REG__(VGA_SEQUENCER_PORT,_GrP8Chain4On,0);		\
	_SetVGAPlaneMask(0xff);						\
	_GrP8PlanarModeOn = FALSE;					\
    }									\
} while(0)


