/** 
 ** P4PIXBLK.C 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p4.h"
#include "memfill.h"
#include "memcopy.h"

void _GrP4SetPixBlock(long addr,int color,int width,int height)
{
	pixptr p = P_ADDRESS(CURC,addr);
	int opr  = C_OPER(color);
	int offs = CURC->gc_lineoffset;
	int plane,lmask,rmask;

	if((width <= 0) || (height <= 0)) return;
	if((_GrP4DrawTable[opr] ^ (color &= C_SIGNIF)) == 0) return;
	_ClrDir();
	_ComputeMasks(addr,width,lmask,rmask);
	if(CURC->gc_onscreen) {
	    _SetVideoColor(color,opr);
	    if(lmask) {
		_SetVGAWriteMask(lmask);
		_ColSetXorB(VLEFT,p,offs,0,height);
		p++;
	    }
	    if(width) {
		_SetVGAWriteMask(0xff);
		plane = offs - width;
		if(opr == C_SET)
		    _BlkSetB(VBODY,p,plane,0,width,height);
		else {
		    _SaveDS();
		    _BlkCpyB(VBODY,p,plane,p,plane,width,height);
		    _RestoreDS();
		}
		p += width;
	    }
	    if(rmask) {
		_SetVGAWriteMask(rmask);
		_ColSetXorB(VRIGHT,p,offs,0,height);
	    }
	    return;
	}
	opr <<= 1;
	for(plane = 4; --plane >= 0; color >>= 1) {
	    pixptr pp = p;
	    switch(opr | (color & 1)) {
	      case C_XOR2+1:
		if(lmask) {
		    _ColSetXorB(MLEFT_X,pp,offs,lmask,height);
		    pp++;
		}
		if(width) {
		    _BlkSetXorB(MBODY_X,pp,(offs - width),0xff,width,height);
		    pp += width;
		}
		if(rmask) {
		    _ColSetXorB(MRIGHT_X,pp,offs,rmask,height);
		}
		break;
	      case C_OR2+1:
	      case C_SET2+1:
		if(lmask) {
		    _ColSetOrB(MLEFT_1,pp,offs,lmask,height);
		    pp++;
		}
		if(width) {
		    _BlkSetB(MBODY_1,pp,(offs - width),0xff,width,height);
		    pp += width;
		}
		if(rmask) {
		    _ColSetOrB(MRIGHT_1,pp,offs,rmask,height);
		}
		break;
	      case C_AND2+0:
	      case C_SET2+0:
		if(lmask) {
		    _ColSetAndB(MLEFT_0,pp,offs,~lmask,height);
		    pp++;
		}
		if(width) {
		    _BlkSetB(MBODY_0,pp,(offs - width),0,width,height);
		    pp += width;
		}
		if(rmask) {
		    _ColSetAndB(MRIGHT_0,pp,offs,~rmask,height);
		}
		break;
	    }
	    p = (pixptr)((long)p + CURC->gc_planeoffset);
	}
}

