/** 
 ** P4FILLP.C 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p4.h"
#include "memfill.h"
#include "memcopy.h"

void _GrP4FillPattern(int x,int y,int width,GrPattern *p)
{
	if(width <= 0) return;
	x += CURC->gc_xoffset;
	y += CURC->gc_yoffset;
	if(p->gp_ispixmap) {
	    GrContext *dst = (CURC->gc_root == NULL) ? CURC : CURC->gc_root;
	    GrContext *src = (GrContext *)(&p->gp_pxp_source);
	    int  pattwdt = p->gp_pxp_width;
	    int  optype  = p->gp_pxp_oper;
	    int  cpysize = x % pattwdt;
	    long dstaddr = PIX_ADDR(dst,x,y);
	    long srcline = PIX_ADDR(src,0,(y % p->gp_pxp_height));
	    long srcaddr = srcline + cpysize;

	    cpysize = pattwdt - cpysize;
	    while(width > 0) {
		if(cpysize > width) cpysize = width;
		_GrP4PixCopy(dst,dstaddr,src,srcaddr,cpysize,1,optype);
		width	-= cpysize;
		dstaddr += cpysize;
		srcaddr  = srcline;
		cpysize  = pattwdt;
	    }
	}
	else {
	    pixptr ptr = (pixptr)
		(CURC->gc_baseaddr + (y * CURC->gc_lineoffset) + (x >> 3));
	    int bits = p->gp_bmp_data[y % p->gp_bmp_height];
	    int fgc  = p->gp_bmp_fgcolor;
	    int bgc  = p->gp_bmp_bgcolor;
	    int fgop = C_OPER(fgc);
	    int bgop = C_OPER(bgc);
	    int dofg = _GrP4DrawTable[fgop] ^ (fgc &= C_SIGNIF);
	    int dobg = _GrP4DrawTable[bgop] ^ (bgc &= C_SIGNIF);
	    int plane,lmask,rmask;

	    _ClrDir();
	    _ComputeMasks(x,width,lmask,rmask);
	    for(x = 2; --x >= 0; fgc = bgc,fgop = bgop,dofg = dobg,bits = ~bits) {
		pixptr p = ptr;
		if(!dofg) continue;
		if(CURC->gc_onscreen) {
		    _SetVideoColor(fgc,fgop);
		    if(lmask) { _SetVGAWriteMask(lmask & bits); (*p)++; p++; }
		    if(width) {
			_SetVGAWriteMask(bits);
			_SaveDS();
			_RowCpyB(VRAM,p,p,width);
			_RestoreDS();
			p += width;
		    }
		    if(rmask) { _SetVGAWriteMask(rmask & bits); (*p)++; }
		    continue;
		}
		fgop <<= 1;
		for(plane = 4; --plane >= 0; fgc >>= 1) {
		    pixptr pp = p;
		    switch(fgop | (fgc & 1)) {
		      case C_XOR2+1:
			if(lmask) *pp++ ^= (lmask & bits);
			if(width) {
			    _RowSetXorB(MEM_X,pp,bits,width);
			    pp += width;
			}
			if(rmask) *pp ^= (rmask & bits);
			break;
		      case C_OR2+1:
		      case C_SET2+1:
			if(lmask) *pp++ |= (lmask & bits);
			if(width) {
			    _RowSetOrB(MEM_1,pp,bits,width);
			    pp += width;
			}
			if(rmask) *pp |= (rmask & bits);
			break;
		      case C_AND2+0:
		      case C_SET2+0:
			if(lmask) *pp++ &= ~(lmask & bits);
			if(width) {
			    _RowSetAndB(MEM_0,pp,~bits,width);
			    pp += width;
			}
			if(rmask) *pp &= ~(rmask & bits);
			break;
		    }
		    p = (pixptr)((long)p + CURC->gc_planeoffset);
		}
	    }
	}
}

