/**
 ** MAKEPAT.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "gmalloc.h"

#define  BEST_MAX_LINE	       128
#define  BEST_MAX_CONTEXT      2048L

/*
 * try to replicate a pixmap for faster bitblt-s
 * in bitplane modes it is especially desirable to replicate until
 * the width is a multiple of 8
 */
int _GrBestPixmapWidth(int wdt,int hgt)
{
	long total   = GrContextSize(wdt,hgt);
	int  linelen = GrLineOffset(wdt);
	int  factor  = 1;
	int  test;

	if(total == 0L) return(0);
#ifdef _MAXMEMPLANESIZE
	if(total > _MAXMEMPLANESIZE) return(0);
#endif
	if((test = (int)(BEST_MAX_CONTEXT / total)) > factor)
	    factor = test;
	if((test = (BEST_MAX_LINE / linelen)) < factor)
	    factor = test;
	while((factor >>= 1) != 0)
	    wdt <<= 1;
	return(wdt);
}

GrPattern *GrBuildPixmap(char *pixels,int w,int h,GrColorTableP ct)
{
	GrContext csave,cwork;
	GrPixmap  *result;
	unsigned  char *src;
	char far  *data;
	int  wdt,wdt2,fullw;
	int  hgt,color;
	long addr;

	if((fullw = _GrBestPixmapWidth(w,h)) <= 0) return(NULL);
	data   = _GrFarMalloc(GrContextSize(fullw,h));
	result = _GrMalloc(sizeof(GrPixmap));
	if((result == NULL) || (data == (char far *)NULL)) {
	    if(result != NULL) _GrFree(result);
	    if(data != (char far *)NULL) _GrFarFree(data);
	    return(NULL);
	}
	GrCreateContext(fullw,h,data,&cwork);
	csave = *CURC;
	*CURC = cwork;
	for(hgt = 0; hgt < h; hgt++) {
	    addr = PIXEL_ADDR(0,hgt);
	    for(wdt2 = fullw; (wdt2 -= w) >= 0; ) {
		src = (unsigned char *)pixels;
		for(wdt = w; --wdt >= 0; ) {
		    color = *src++;
		    if(ct != NULL) color = GR_CTABLE_COLOR(ct,color);
		    _GrSetPixel(addr,(color & C_COLOR));
		    addr += PIXEL_SIZE;
		}
	    }
	    pixels += w;
	}
	*CURC = csave;
	result->pxp_source = *((GrVidRAM *)&cwork);
	result->pxp_source.gc_memflags = (GCM_MYCONTEXT | GCM_MYMEMORY);
	result->pxp_ispixmap = TRUE;
	result->pxp_width  = fullw;
	result->pxp_height = h;
	result->pxp_oper   = 0;
	return((GrPattern *)result);
}

GrPattern *GrBuildPixmapFromBits(char *bits,int w,int h,int fgc,int bgc)
{
	GrContext csave,cwork;
	GrPixmap  *result;
	unsigned  char *src;
	char far  *data;
	int  wdt,wdt2,fullw;
	int  hgt,mask,byte;
	long addr;

	if((fullw = _GrBestPixmapWidth(w,h)) <= 0) return(NULL);
	data   = _GrFarMalloc(GrContextSize(fullw,h));
	result = _GrMalloc(sizeof(GrPixmap));
	if((result == NULL) || (data == (char far *)NULL)) {
	    if(result != NULL) _GrFree(result);
	    if(data != (char far *)NULL) _GrFarFree(data);
	    return(NULL);
	}
	GrCreateContext(fullw,h,data,&cwork);
	csave = *CURC;
	*CURC = cwork;
	fgc &= C_COLOR;
	bgc &= C_COLOR;
	for(hgt = 0; hgt < h; hgt++) {
	    addr = PIXEL_ADDR(0,hgt);
	    for(wdt2 = fullw; (wdt2 -= w) >= 0; ) {
		src  = (unsigned char *)bits;
		mask = byte = 0;
		for(wdt = w; --wdt >= 0; ) {
		    if((mask >>= 1) == 0) { mask = 0x80; byte = *src++; }
		    _GrSetPixel(addr,((byte & mask) ? fgc : bgc));
		    addr += PIXEL_SIZE;
		}
	    }
	    bits += (w + 7) >> 3;
	}
	*CURC = csave;
	result->pxp_source = *((GrVidRAM *)&cwork);
	result->pxp_source.gc_memflags = (GCM_MYCONTEXT | GCM_MYMEMORY);
	result->pxp_ispixmap = TRUE;
	result->pxp_width  = fullw;
	result->pxp_height = h;
	result->pxp_oper   = 0;
	return((GrPattern *)result);
}

GrPattern *GrConvertToPixmap(GrContext *src)
{
	GrPixmap *result;

	if(src->gc_onscreen) return(NULL);
	result = _GrMalloc(sizeof(GrPixmap));
	if(result == NULL) return(NULL);
	result->pxp_source = *((GrVidRAM *)src);
	result->pxp_source.gc_memflags = GCM_MYCONTEXT;
	result->pxp_ispixmap = TRUE;
	result->pxp_width  = src->gc_xmax + 1;
	result->pxp_height = src->gc_ymax + 1;
	result->pxp_oper   = 0;
	return((GrPattern *)result);
}


void GrDestroyPattern(GrPattern *p)
{
	if(p->gp_ispixmap) {
	    if(p->gp_pxp_source.gc_memflags & GCM_MYMEMORY)
		_GrFarFree(p->gp_pxp_source.gc_baseaddr);
	    if(p->gp_pxp_source.gc_memflags & GCM_MYCONTEXT)
		_GrFree(p);
	    return;
	}
	if(p->gp_bitmap.bmp_memflags) _GrFree(p);
}

