/**
 ** M16FILLP.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  Copyright (C) 1995, Daniel Jackson
 **    4915 S.W. Greensboro Way #257 Beaverton Or. 97007
 **    djackson@ichips.intel.com
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "m16.h"

static int bg_mixtable[] = {
    BSS_BKGDCOL | MIX_SRC,	      /* C_SET */
    BSS_BKGDCOL | MIX_XOR,	      /* C_XOR */
    BSS_BKGDCOL | MIX_OR,	      /* C_OR  */
    BSS_BKGDCOL | MIX_AND	      /* C_AND */
};

void _GrM16FillPattern(int x,int y,int width, GrPattern *p)
{

	if(width <= 0) return;

	if(p->gp_ispixmap) {
	    int patw = p->gp_pxp_width;
	    /* Adjust for pixel sizeof(short) */
	    int xpos = (x + CURC->gc_xoffset) % patw;
	    int ypos = (y + CURC->gc_yoffset) % p->gp_pxp_height;

	    while(width > 0) {
	    	int curw = MIN(width,(patw - xpos));

		_GrM16PixCopy(CURC,PIX_ADDR(CURC,x,y),
			(GC *)(&p->gp_pxp_source),
			PIX_ADDR(&p->gp_pxp_source,xpos,ypos),
			curw,
			1,
			p->gp_pxp_oper);
			        
		width -= curw;
		x += curw;
		xpos = 0;
	    }
	    return;
	}
	if(CURC->gc_onscreen) {
	    int fgc,bgc,bits,fgop,bgop;
	    x += CURC->gc_xoffset;
	    y += CURC->gc_yoffset;
	    bits = p->gp_bmp_data[y % p->gp_bmp_height];
	    fgc  = p->gp_bmp_fgcolor;
	    bgc  = p->gp_bmp_bgcolor;
	    fgop = C_OPER(fgc);
	    bgop = C_OPER(bgc);

	    WaitQueue(6);
	    outpw(FRGD_COLOR,fgc);
	    outpw(BKGD_COLOR,bgc);
	    outpw(FRGD_MIX,_GrM16MixTable[fgop]);
	    outpw(BKGD_MIX,bg_mixtable[bgop]);
	    outpw(CUR_X,x);
	    outpw(CUR_Y,y);
	    WaitQueue(6);
	    outpw(MAJ_AXIS_PCNT,(width - 1));
	    outpw(MULTIFUNC_CNTL,(PATTERN_L | (bits << 1)));
	    outpw(MULTIFUNC_CNTL,(PATTERN_H | (bits >> 3)));
	    outpw(MULTIFUNC_CNTL,(PIX_CNTL | MIXSEL_PATT));
	    outpw(CMD,(CMD_LINE | LINETYPE | VECDIR_000 | DRAW | PLANAR | WRTDATA));
	    outpw(MULTIFUNC_CNTL,(PIX_CNTL | 0));
	    return;
	}

	_GrPHFillPattern(x,y,width,p);
}

