/**
 ** LOADDRV.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#pragma  inline

#include "grx.h"
#include "libgrx.h"
#include "grdriver.h"
#include "grxfile.h"
#include "gmalloc.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>

static char driver_loaded = FALSE;
static char new_driver = FALSE;

static void far dummy_func(void) {}
static GrDriverHeader far *drv;

static void far (*set_mode_func)(void) = dummy_func;
static void far (*set_page_func)(void) = dummy_func;
static unsigned short far *option_word_address;


static char *near get_token(char *p,char *token)
{
	while(*p == ' ') p++;
	while(*p && (*p != ' ')) { *token++ = tolower(*p); p++; }
	*token = '\0';
	return(p);
}

static int near find_keyword(char *p,char *token,char *name)
{
	while(*p != '\0') {
	    p = get_token(p,token);
	    if(strcmp(token,name) == 0) {
		p = get_token(p,token);
		return((*token == '\0') ? FALSE : TRUE);
	    }
	}
	return(FALSE);
}

static void near load_driver(int errors_fatal)
{
	void far (*drv_init_func)(void);
	char *p,driver[100];
	int  drvfile,test;
	long size;

	if((p = getenv("GRXDRV")) == NULL) {
	    if(((p = getenv("GO32")) == NULL) ||
	       (find_keyword(p,driver,"driver") == FALSE)) {
		if(!errors_fatal) return;
		fputs("No graphics driver specified\n",stderr);
		exit(1);
	    }
	}
	else p = get_token(p,driver);
	if((drvfile = open(driver,(O_RDONLY | O_BINARY))) < 0) {
	    if(!errors_fatal) return;
	    fputs("Graphics driver \"",stderr);
	    fputs(driver,stderr);
	    fputs("\" not found\n",stderr);
	    exit(1);
	}
	size = filelength(drvfile);
	if(!(drv = _GrFarMalloc(size + 16))) {
	    if(!errors_fatal) return;
	    fputs("No memory for graphics driver\n",stderr);
	    exit(1);
	}
	drv = MK_FP((FP_SEG(drv) + ((FP_OFF(drv) + 15) >> 4)),0);
	if(_GrFarRead(drvfile,drv,size) != size) {
	    if(!errors_fatal) return;
	    fputs("Error loading graphics driver\n",stderr);
	    close(drvfile);
	    exit(1);
	}
	close(drvfile);
	option_word_address = &drv->driver_flags;
	if(*option_word_address & GRD_NEW_DRIVER) new_driver = TRUE;
	if(find_keyword(p,driver,"tw") && ((test = atoi(driver)) > 0)) drv->def_tw = test;
	if(find_keyword(p,driver,"th") && ((test = atoi(driver)) > 0)) drv->def_th = test;
	if(find_keyword(p,driver,"gw") && ((test = atoi(driver)) > 0)) drv->def_gw = test;
	if(find_keyword(p,driver,"gh") && ((test = atoi(driver)) > 0)) drv->def_gh = test;
	set_mode_func = (void far (*)())MK_FP(FP_SEG(drv),drv->modeset_routine);
	set_page_func = (void far (*)())MK_FP(FP_SEG(drv),drv->paging_routine);
	if(new_driver) {
	    if(find_keyword(p,driver,"nc") && ((test = atoi(driver)) > 0))
		drv->def_numcolor = test;
	    drv_init_func = (void far (*)())MK_FP(FP_SEG(drv),drv->driver_init_routine);
	    asm push di;
	    asm push si;
	    _BX = FP_OFF((void far *)&drv_init_func);
	    _ES = FP_SEG((void far *)&drv_init_func);
	    asm push ds;
	    asm push WORD  PTR es:[bx+2]
	    asm pop  ds;
	    asm call DWORD PTR es:[bx];
	    asm pop  ds;
	    asm pop  si;
	    asm pop  di;
	    if(_AX == 0) {
		if(!errors_fatal) return;
		/* You may want to do something more appropriate here */
		fputs("Graphics initialization error -- probably incorrect driver\n",stderr);
		exit(1);
	    }
	}
	driver_loaded = TRUE;
}

long _GrLowSetMode(int mode,int width,int height,int colors)
{
	int retval;

	if(!driver_loaded) {
	    load_driver((mode >= GR_320_200_graphics) ? TRUE : FALSE);
	    if(!driver_loaded) {
		_AX = 3;
		geninterrupt(0x10);
		return(-1);
	    }
	}
	if(!new_driver && (mode == 9)) mode = 6;
	asm push di;
	asm push si;
	_SI = FP_OFF((void far *)&set_mode_func);
	_ES = FP_SEG((void far *)&set_mode_func);
	asm mov  bx,colors;
	asm mov  cx,width;
	asm mov  dx,height;
	asm mov  ax,mode;
	asm push ds;
	asm push WORD  PTR es:[si+2]
	asm pop  ds;
	asm call DWORD PTR es:[si];
	asm pop  ds;
	retval = _BX;
	_GrScreenX = _CX;
	_GrScreenY = _DX;
	asm pop  si;
	asm pop  di;
	return(new_driver ? retval : *option_word_address);
}

long _GrGetDriverModes(GR_DRIVER_MODE_ENTRY far **t,GR_DRIVER_MODE_ENTRY far **g)
{
	if(!driver_loaded) load_driver(TRUE);
	if(new_driver) {
	   *t = MK_FP(FP_SEG(drv),drv->text_table);
	   *g = MK_FP(FP_SEG(drv),drv->graphics_table);
	}
	else {
	   *t = (GR_DRIVER_MODE_ENTRY far *)NULL;
	   *g = (GR_DRIVER_MODE_ENTRY far *)NULL;
	}
	return(drv->driver_flags);
}

/*
 * C entry point
 */
void _GrSetVideoPage(int page)
{
	asm push di;
	asm push si;
	_AX = page;
	(*set_page_func)();
	asm pop  si;
	asm pop  di;
}

/*
 * ASM entry point: page(s) in AX
 */
void far _GrSetAsmPage(void)
{
	asm push di;
	asm push si;
	asm push dx;
	asm push cx;
	asm push bx;
	(*set_page_func)();
	asm pop  bx;
	asm pop  cx;
	asm pop  dx;
	asm pop  si;
	asm pop  di;
}

