#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <termios.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/vt.h>
#include <linux/keyboard.h>
#include <vgakeyboard.h>
#include <mousex.h>
#include <grx.h>
#include <gppconio.h>

extern char *KeyBoardTable;

static char SKey[NR_KEYS];
static int Special[] = {LEFT_SHIFT, RIGHT_SHIFT,
			LEFT_ALT,   LEFT_CTRL,
			CAPS_LOCK,  SCROLL_LOCK,
			NUM_LOCK,   INSERT_KEY };



typedef struct keyboard {
	int KbMode;
	int ScanCode;
	int KeyCode;
} KeyBoard;

static KeyBoard  NewKey = { 0, 0, 0 };

/* Check to see if we have a valid Keyboard hit */
/* if we see any of the special keys log them   */
/* and tell caller no keys yet.                 */
static int RawGetKey()
{
	int Found, i;

	
	Found = 0;
        usleep(100);


        /* if no key has been pressed return */
	if (keyboard_update() == 0) {
		return 0;
	}
	
	for (i = 0; i < NR_KEYS; i++) {
	   if (KeyBoardTable[i] != 0)
		switch (i)
		{
			case LEFT_SHIFT:   NewKey.KbMode |= KB_LEFTSHIFT;  break;
	 		case RIGHT_SHIFT:  NewKey.KbMode |= KB_RIGHTSHIFT; break;
			case LEFT_ALT:	   NewKey.KbMode |= KB_ALT;        break;
			case LEFT_CTRL:	   NewKey.KbMode |= KB_CTRL;       break;
			case CAPS_LOCK:	   NewKey.KbMode |= KB_CAPSLOCK;   break;
			case SCROLL_LOCK:  NewKey.KbMode |= KB_SCROLLOCK;  break;
			case NUM_LOCK:     NewKey.KbMode |= KB_NUMLOCK;    break;
			case INSERT_KEY:   NewKey.KbMode |= KB_INSERT;     break;
			default:
		                NewKey.ScanCode = i;
				Found = 1;
				while (!keyboard_update());
				/* keyboard_clearstate();  */
		}
	}
	return Found;
}

static int no(char *s) {

	if (GrCurrentMode() >= GR_320_200_graphics)
		GrSetMode(GR_default_text);
	fprintf(stderr, "\n\nFunction %s not available. Use ncurses based conio routines!\n", s);
	exit(1);

}

int wherex(void) {
	return no("wherex");
}

int wherey(void) {
	return no("wherey");
}

int kbhit(void)
{
	struct termios told, tnew;
	struct timeval timeout;
	struct fd_set  readfds, writefds, exceptfds;
	int tmp;

	if (GrGetKeyMode() == GR_RAW)
		return (RawGetKey());		
	
	fflush(stdout);
	if (tcgetattr( fileno(stdin), &told) != 0)
		return (1==1);
	memcpy( &tnew, &told, sizeof(tnew));
	tnew.c_lflag &= ~(ICANON|ECHO);
	tnew.c_cc[VMIN]  = 0;
	tnew.c_cc[VTIME] = 0;
	tcsetattr( fileno(stdin), TCSANOW, &tnew);
	FD_ZERO(&readfds);
	FD_SET(fileno(stdin), &readfds);
	FD_ZERO(&writefds);
	FD_ZERO(&exceptfds);
	timeout.tv_sec=0;
	timeout.tv_usec=0;
	select(1, &readfds, &writefds, &exceptfds, &timeout);
	tcsetattr( fileno(stdin), TCSANOW, &told);
	return FD_ISSET(fileno(stdin), &readfds) != 0;

}

int getkbstat()
{
	int Kbstat = 0, tmp = 0;

	if (GrGetKeyMode() == GR_RAW)
	{
		Kbstat = NewKey.KbMode;
		NewKey.KbMode = 0;
	}
	else
	{
	 	tmp = 6;
	  	ioctl(fileno(stdin), TIOCLINUX, &tmp);
		/* remap keys */
		if (_KB_RIGHT_ALT_ & tmp)
			Kbstat |= KB_ALT;
		if (_KB_LEFT_ALT_ & tmp)
			Kbstat |= KB_ALT;
		if (_KB_CTRL_ & tmp)
			Kbstat |= KB_CTRL;
		if (_KB_SHIFT_ & tmp)
			Kbstat |= (KB_LEFTSHIFT| KB_RIGHTSHIFT);
	}
	return Kbstat;
}

int getkey(void)
{
	struct termios told, tnew;
	int c;
	
	if (GrGetKeyMode() == GR_RAW)
	{
		if (NewKey.KeyCode == 0)
			while (!kbhit());

		if ((NewKey.KeyCode == KEY_C) && (NewKey.KbMode & KB_CTRL))
		{
			GrSetMode(GR_default_text);
			printf("\nRecived Control ^C exiting program\n");
			exit(0);
		}
		c = NewKey.ScanCode;
		NewKey.ScanCode = 0;
	}
	else
	{

		fflush(stdout);
		if (tcgetattr( fileno(stdin), &told) != 0)
			return -1;
		memcpy( &tnew, &told, sizeof(tnew));
		tnew.c_lflag &= ~(ICANON|ECHO);	
		tnew.c_cc[VMIN]  = 1;
		tnew.c_cc[VTIME] = 0;
		tcsetattr( fileno(stdin), TCSANOW, &tnew);
		c = fgetc( stdin);
		tcsetattr( fileno(stdin), TCSANOW, &told);
	}
	return c;
}

int getch(void) {
	return getkey();
}

int getche(void) {
  int ch;

	ch = getkey();
	putch(ch);
	return ch;
}

void window(int left, int top, int right, int bottom) {
	no("window");
}

int gettext(int left, int top, int right, int bottom, void *dst) {
	return no("gettext");
}

int puttext(int left, int top, int right, int bottom, void *src) {
	return no("puttext");
}

int movetext(int left, int top, int right, int bottom, int dleft, int dtop) {
	return no("movetext");
}

void gettextinfo(struct text_info *r) {
	no("gettextinfo");
}


void textbackground( int color ) {
	switch (color)
	{
		case 0: break;
		case 1: color = 4; break;
		case 2: break;
		case 3: color = 6; break;
		case 4: color = 1; break;
		case 5: break;
		case 6: color = 3; break;
		case 7: break;
		default: return;
	}
	printf("\033[%dm", color + 40);
	fflush(stdout);
}

void textcolor( int color ) {
	int high = 0;

	if ( color > 7 && color < 16)
	{
		high = 1;
		color -= 8;
	}
	switch (color)
	{
		case 0: break;
		case 1: color = 4; break;
		case 2: break;
		case 3: color = 6; break;
		case 4: color = 1; break;
		case 5: break;
		case 6: color = 3; break;
		case 7: break;
		default: return;
	}
	printf("\033[%d;%dm", high, color + 30);
	fflush(stdout);
}

void textattr(int attr) {

	if ((attr&BLINK) != 0)
		printf("\033[5m"); /* blink  */

	textcolor(attr&0x0F);
	textbackground( (attr>>4)&0x07);
}

void _lnxconio_clearall(void) {
	clrscr();
}


 
