/**
 ** GMALLOC.H
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#if defined(__GNUC__) && !defined(near)
# define near
# define far
# define huge
#endif

#ifdef __TURBOC__
# include  <alloc.h>
  extern   void far *_GrFarMalloc(unsigned long size);
  extern   void	     _GrFarFree(void far *ptr);
#endif

#ifdef __GNUC__
# include  <malloc.h>
# define   _GrFarMalloc(size)	_GrMalloc(size)
# define   _GrFarFree(ptr)	_GrFree(ptr)
#endif

extern void	*_GrMalloc(unsigned int size);
extern void	 _GrFree(void *ptr);

extern char far *_GrVidAlloc(unsigned int size);
extern void	 _GrVidFree(char far *ptr);
extern void	 _GrVidMemInit(char far *start,unsigned int size);

#ifdef __TURBOC__
  extern char far *_GrGetTempBuffer(int size);
#endif

#ifdef __GNUC__
# define _GrGetTempBuffer(size)		__builtin_alloca(size)
#endif


