/**
 ** FRAMBOX.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"

void GrFramedBox(int x1,int y1,int x2,int y2,int wdt,GrFBoxColors *c)
{
	MOUSE_FLAG;

	SORT2(x1,x2);
	SORT2(y1,y2);
	if(wdt < 0) wdt = 0;
	MOUSE_BLOCK(CURC,(x1 - wdt),(y1 - wdt),(x2 + wdt),(y2 + wdt));
	if(c->fbx_intcolor != GrNOCOLOR)
	    GrFilledBox(x1,y1,x2,y2,c->fbx_intcolor);
	while(--wdt >= 0) {
	    x1--; x2++;
	    y1--; y2++;
	    GrHLine(x1,x2,y1,c->fbx_topcolor);
	    GrVLine(x1,(y1 + 1),(y2 - 1),c->fbx_leftcolor);
	    GrVLine(x2,(y1 + 1),(y2 - 1),c->fbx_rightcolor);
	    GrHLine(x1,x2,y2,c->fbx_bottomcolor);
	}
	MOUSE_UNBLOCK();
	GrFlush();
}

