/** 
 ** FILEUTIL.C 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "grxfile.h"
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <fcntl.h>

void _GrSetPath(char *name,char *pathbuffer)
{
	char *p;

	if(name != NULL) {
	    for(p = name; isspace(*p); p++);
	    if(*p != '\0') {
		strcpy(pathbuffer,p);
		for(p = pathbuffer; (*p != '\0') && !isspace(*p); p++)
		    *p = (*p == '\\') ? '/' : tolower(*p);
		if(p[-1] != '/')
		    *p++ = '/';
		*p = '\0';
		return;
	    }
	}
	strcpy(pathbuffer,"./");
}

char *_GrGetFname(char *name,char *path,char *env,char *ext,char *where)
{
	char temp[200];
	char *p;

	where[0] = '\0';
	for(p = name; isspace(*p); p++);
	strcpy(temp,p);
	for(p = temp; (*p != '\0') && !isspace(*p); p++)
	    *p = (*p == '\\') ? '/' : tolower(*p);
	*p = '\0';
	if((ext != NULL) &&
	   (((p = strrchr(temp,'.')) == NULL) || (strchr(p,'/') != NULL)))
	    strcat(temp,ext);
	if((strchr("./",temp[0]) == NULL) && (temp[1] != ':')) {
	    if(path[0] == '\0') {
		p = ((env != NULL) && (env[0] != '\0')) ? getenv(env) : NULL;
		_GrSetPath(p,path);
	    }
	    strcpy(where,path);
	}
	strcat(where,temp);
	return(where);
}

int _GrFileOpen(char *name)
{
	return(open(name,(O_RDONLY)));
}

void _GrFileClose(int handle)
{
	close(handle);
}

#ifdef __TURBOC__

#include <dos.h>

long _GrFarRead(int file,void far *bp,long size)
{
	char b[1024];
	long total = 0;
	int  step,test;

	while(size > 0L) {
	    if((long)(step = 1024) > size) step = (int)size;
	    if((test = read(file,b,step)) != step) {
		if((step = test) < 0) {
		    step = 0;
		    if(total == 0L) total = -1L;
		}
		size = 0L;
	    }
	    if(step) movedata(FP_SEG(b),FP_OFF(b),FP_SEG(bp),FP_OFF(bp),step);
	    bp = (void far *)((char huge *)bp + (long)step);
	    total += (long)step;
	    size  -= (long)step;
	}
	return(total);
}

#endif


