/**
 ** CUSTLINE.H
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "thicklne.h"

void _GrDoCustomCorner(int x,int y,void *arg)
{
	GrCustomLineData *dta = (GrCustomLineData *)arg;

	if((dta->opt.lno_width >= 3) &&
	   !dta->is_XOR_color &&
	   (dta->total_pattlen == 0)) _GrScanEllipse(x,y,
	    dta->opt.lno_width >> 1,
	    dta->opt.lno_width >> 1,
	    TRUE,
	    FALSE,
	    dta->pixelproc,
	    dta->borderproc,
	    dta->scanfillproc,
	    dta->fillarg
	);
}

void GrCustomPolyLine(int numpts,int points[][2],GrLineOption *o)
{
	GrCustomLineData args;

	_GrBuildCustomLineData(o,&args);
	_GrSetupSolidDraw(&o->lno_color,&args);
	_GrDrawPolygon(numpts,points,
	    FALSE,
	    TRUE,
	    _GrDoCustomCorner,
	    _GrDoCustomSegment,
	    &args
	);
}

void GrCustomPolygon(int numpts,int points[][2],GrLineOption *o)
{
	GrCustomLineData args;

	_GrBuildCustomLineData(o,&args);
	_GrSetupSolidDraw(&o->lno_color,&args);
	_GrDrawPolygon(numpts,points,
	    TRUE,
	    TRUE,
	    _GrDoCustomCorner,
	    _GrDoCustomSegment,
	    &args
	);
}

void GrCustomBox(int x1,int y1,int x2,int y2,GrLineOption *o)
{
	GrCustomLineData args;
	int points[4][2];

	points[0][0] = x1; points[0][1] = y1;
	points[1][0] = x1; points[1][1] = y2;
	points[2][0] = x2; points[2][1] = y2;
	points[3][0] = x2; points[3][1] = y1;
	_GrBuildCustomLineData(o,&args);
	_GrSetupSolidDraw(&o->lno_color,&args);
	_GrDrawPolygon(4,points,
	    TRUE,
	    TRUE,
	    _GrDoCustomCorner,
	    _GrDoCustomSegment,
	    &args
	);
}

