/**
 ** BITBLT.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "clipping.h"

void GrBitBlt(GrContext *dst,int x,int y,
	      GrContext *src,int x1,int y1,int x2,int y2,int oper)
{
	int oldx,oldy;
	int msflag = FALSE;

	if(dst == NULL) dst = CURC;
	if(src == NULL) src = CURC;
	SORT2(x1,x2);
	SORT2(y1,y2);
	oldx = x1;
	oldy = y1;


        if (GrGetMemCfg() == BANKED_MODE)
            GrDirtyCheck(dst, x, y, x+x2, y+y2);

	CLIPBOXTOCONTEXT(src,x1,y1,x2,y2);
	x += (x1 - oldx);
	y += (y1 - oldy);
	x2 += ((oldx = x) - x1);
	y2 += ((oldy = y) - y1);
	CLIPBOX(dst,x,y,x2,y2);
	x1 += (x - oldx);
	y1 += (y - oldy);
	if(_GrMouseDrawn) {
	    GrContext *cxt = NULL;
	    int mx1,my1,mx2,my2;
	    if(src->gc_onscreen) {
		cxt = src->gc_root ? src->gc_root : src;
		mx1 = x1  + src->gc_xoffset;
		my1 = y1  + src->gc_yoffset;
		mx2 = mx1 + x2 - x;
		my2 = my1 + y2 - y;
	    }
	    if(dst->gc_onscreen) {
		cxt = dst->gc_root ? dst->gc_root : dst;
		mx1 = MIN(mx1,x  + dst->gc_xoffset);
		my1 = MIN(my1,y  + dst->gc_yoffset);
		mx2 = MAX(mx2,x2 + dst->gc_xoffset);
		my2 = MAX(my2,y2 + dst->gc_yoffset);
	    }
	    if(cxt) msflag = (*_GrMouseBlock)(cxt,mx1,my1,mx2,my2);
	    if (GrGetMemCfg() == BANKED_MODE)
                GrDirtyCheck(cxt, mx1, my1, mx2, my2);
	}

        if (GrGetMemCfg() == BANKED_MODE)
            GrDirtyCheck(dst, x, y, x+(x2-x1), y+(y2-y1));

	_GrPixCopy(dst,PIX_ADDR(dst,x,y),
	    src,PIX_ADDR(src,x1,y1),
	    (x2 - x + 1),
	    (y2 - y + 1),
	    oper
	);
	if(msflag) (*_GrMouseUnBlock)(msflag);
	else
	    if (GrGetMemCfg() == BANKED_MODE)
                GrFlush();
}

