/**
 ** MOUSEX.H
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#ifndef _MOUSEX_H_
#define _MOUSEX_H_

#ifndef _GRX_H_
# include <grx.h>
#endif

/*
 * MOUSE event flag bits
 * (changed to reflect MS mouse driver conventions)
 */
#ifndef M_MOTION			/* "eventque.h" also defines these */

#define M_MOTION	0x001
#define M_LEFT_DOWN	0x002
#define M_LEFT_UP	0x004
#define M_RIGHT_DOWN	0x008
#define M_RIGHT_UP	0x010
#define M_MIDDLE_DOWN	0x020
#define M_MIDDLE_UP	0x040
#define M_BUTTON_DOWN	(M_LEFT_DOWN | M_MIDDLE_DOWN | M_RIGHT_DOWN)
#define M_BUTTON_UP	(M_LEFT_UP   | M_MIDDLE_UP   | M_RIGHT_UP)
#define M_BUTTON_CHANGE (M_BUTTON_UP | M_BUTTON_DOWN )

/*
 * MOUSE button status bits
 */
#define M_LEFT		4
#define M_RIGHT		1
#define M_MIDDLE	2

#endif  /* M_MOTION */

#define M_KEYPRESS	0x080
#define M_POLL		0x100
#define M_NOPAINT	0x200
#define M_EVENT		(M_MOTION | M_KEYPRESS | M_BUTTON_DOWN | M_BUTTON_UP)


/*
 * KEYBOARD status word bits
 */

#ifndef KB_SHIFT		/* "eventque.h" also defines these */
#define _KB_RIGHT_ALT_	0x02	/* right shift key depressed */
#define _KB_LEFT_ALT_	0x08	/* left shift key depressed */
#define _KB_CTRL_	0x04	/* CTRL depressed */
#define _KB_SHIFT_	0x01	/* ALT depressed */

#define KB_RIGHTSHIFT	0x01	/* right shift key depressed */
#define KB_LEFTSHIFT	0x02	/* left shift key depressed */
#define KB_CTRL		0x04	/* CTRL depressed */
#define KB_ALT		0x08	/* ALT depressed */
#define KB_SCROLLOCK	0x10	/* SCROLL LOCK active */
#define KB_NUMLOCK	0x20	/* NUM LOCK active */
#define KB_CAPSLOCK	0x40	/* CAPS LOCK active */
#define KB_INSERT	0x80	/* INSERT state active */

#define KB_SHIFT	(KB_LEFTSHIFT | KB_RIGHTSHIFT)

#endif  /* KB_SHIFT */

/*
 * MOUSE CURSOR modes:
 *  M_CUR_NORMAL -- just the cursor
 *  M_CUR_RUBBER -- rectangular rubber band (XOR-d to the screen)
 *  M_CUR_LINE	 -- line attached to the cursor
 *  M_CUR_BOX	 -- rectangular box dragged by the cursor
 */
#define M_CUR_NORMAL	0
#define M_CUR_RUBBER	1
#define M_CUR_LINE	2
#define M_CUR_BOX	3

#ifdef __cplusplus
extern "C" {
#endif

/*
 * mouse event buffer structure
 */
typedef struct {
    int  flags;				/* flags (see above) */
    int  x,y;				/* coordinates */
    int  buttons;			/* button state */
    int  key;				/* key code from keyboard */
    int  kbstat;			/* keybd status (ALT, CTRL, etc..) */
    long time;				/* time stamp of the event */
} MouseEvent;

/*
 * graphics cursor structure
 */
typedef struct {
    GrVidRAM  cr_andmask;		/* cursor bitmap to AND */
    GrVidRAM  cr_ormask;		/* cursor bitmap to OR */
    GrVidRAM  cr_work;			/* work area */
    GrVidRAM  cr_save;			/* screen save area */
    int	  cr_xcord,cr_ycord;		/* cursor position on screen */
    int	  cr_xsize,cr_ysize;		/* cursor size */
    int	  cr_xoffs,cr_yoffs;		/* LU corner to hot point offset */
    int	  cr_xwork,cr_ywork;		/* save/work area sizes */
    int	  cr_xwpos,cr_ywpos;		/* save/work area position on screen */
    int	  cr_displayed;			/* set if displayed */
} GrCursor;

int  getkey(void);
int  getxkey(void);
int  getkbstat(void);

#ifdef __GNUC__
  int  kbhit(void);
  long clock(void);
  long rawclock(void);
#endif

GrCursor *GrBuildCursor(char *data,int w,int h,int xo,int yo,GrColorTableP c);
GrCursor *GrLoadCursor(char *fname,GrColorTableP colors);
void GrDestroyCursor(GrCursor *cursor);
void GrDisplayCursor(GrCursor *cursor);
void GrEraseCursor(GrCursor *cursor);
void GrMoveCursor(GrCursor *cursor,int x,int y);

int  MouseDetect(void);
void MouseEventMode(int use_interrupts);
void MouseInit(void);
void MouseUnInit(void);
void MouseSetSpeed(int speed);
void MouseSetAccel(int thresh,int accel);
void MouseSetLimits(int x1,int y1,int x2,int y2);
void MouseGetLimits(int *x1,int *y1,int *x2,int *y2);
void MouseWarp(int x,int y);
void MouseEventEnable(int enable_kb,int enable_ms);
void MouseGetEvent(int flags,MouseEvent *event);
int  MousePendingEvent(void);

GrCursor *MouseGetCursor(void);
void MouseSetCursor(GrCursor *cursor);
void MouseSetColors(int fg,int bg);
void MouseSetCursorMode(int mode,...);
void MouseDisplayCursor(void);
void MouseEraseCursor(void);
int  MouseBlock(GrContext *c,int x1,int y1,int x2,int y2);
void MouseUnBlock(int return_value_from_MouseBlock);
int  MouseCursorIsDisplayed(void);

/*
 * call formats for 'MouseSetCursorMode': (all args are integers)
 *  MouseSetCursorMode(M_CUR_NORMAL);
 *  MouseSetCursorMode(M_CUR_RUBBER,xanchor,yanchor,color);
 *  MouseSetCursorMode(M_CUR_LINE,xanchor,yanchor,color);
 *  MouseSetCursorMode(M_CUR_BOX,dx1,dy1,dx2,dy2,color);
 */

#ifdef __cplusplus
}
#endif

#endif /* _MOUSEX_H_ */

