/**
 ** GRXFILE.H
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#ifndef _GRXFILE_H_
#define _GRXFILE_H_

#if defined(__GNUC__) && !defined(near)
# define near
# define far
# define huge
#endif

#define  FONT_MAGIC	0x19590214L
#define  FONTDIR_MAGIC  0x19270104L
#define  CURSOR_MAGIC	0x18480315L
#define  BITMAP_MAGIC	0x19390901L
#define  PIXMAP_MAGIC	0x19700302L
#define  ICON_MAGIC	0x19840728L
#define  RGBDIR_MAGIC	0x19561023L

/*
 * font file structure:
 *	+-----------------------+
 *	|     MAGIC NUMBER	|
 *	+-----------------------+
 *	|     BITMAP SIZE	|
 *	+-----------------------+
 *	|     FONT HEADER	|
 *	+-----------------------+
 *	|     PROPORTIONAL	|
 *	|     WIDTH TABLE	|
 *	|     (16 bit ints)	|
 *	|     (optional)	|
 *	+-----------------------+
 *	|     BITMAP		|
 *	+-----------------------+
 */

typedef struct {
    long    magic;			/* magic number */
    long    bitmapsize;			/* size of the bitmap */
    GrFont  h;				/* font header */
} FntFileHdr;

/*
 * font directory file structure:
 *	+-----------------------+
 *	|   MAGIC NUMBER	|
 *	+-----------------------+
 *	|   # OF ENTRIES	|
 *	+-----------------------+
 *	|   1st FONT HEADER	|
 *	+-----------------------+
 *	|   2nd FONT HEADER	|
 *	+-----------------------+
 *	|	    :		|
 *	|	    :		|
 *	+-----------------------+
 *	|   last FONT HEADER	|
 *	+-----------------------+
 */

typedef struct {
    long    magic;			/* magic number */
    long    numentries;			/* # of GrFont structures in file */
} FntDirHdr;

#define FNTENV  "GRXFONT"		/* font path environment variable */
#define FNTEXT  ".fnt"			/* font file extension */
#define DIREXT  ".dir"			/* font directory file extension */
extern  char	_GrFontPath[];		/* user specified font path */

/*
 * loaded resource list management
 */
typedef struct _reslist {		/* list of loaded resources */
    struct _reslist *next;		/* next item */
    void   *data;			/* the resource */
    char   name[1];			/* full path name to the resource */
} ResList;

extern void  _GrAddToResList(void *data,char *name,ResList **list);
extern void  _GrRemoveFromResList(void *data,ResList **list);
extern void *_GrLookupInResList(char *name,ResList *list);


/*
 * file utilities
 */
extern void  _GrSetPath(char *name,char *pathbuffer);
extern char *_GrGetFname(char *name,char *path,char *env,char *ext,char *where);
extern int   _GrFileOpen(char *name);
extern void  _GrFileClose(int handle);

#ifdef __GNUC__
# define _GrFarRead(file,buff,size)	read(file,buff,(int)size)
#endif

#ifdef __TURBOC__
  extern long _GrFarRead(int file,void far *buff,long size);
#endif

#endif /* whole file */

