#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __linux__
#  error vgatime.c will not work with Linux!
#endif
 
#ifdef __TURBOC__
#include <graphics.h>
#include <conio.h>
#include <dos.h>
#define TickTime (1.0/1193182.0)

#define init_timer() do { \
  asm mov al, 034h;       \
  asm out 043h, al;       \
  asm xor al, al;         \
  asm out 040h, al;       \
  asm out 040h, al;       \
} while(0)

static short ReadTimer(void)
{
  asm  mov   al, 4;
  asm  out   43h, al;
  asm  in    al, 40h;
  asm  mov   bl, al;
  asm  in    al, 40h;
  asm  mov   ah, al;
  asm  mov   al, bl;
  asm  not   ax;
  return _AX;
}

#define CRTC_BASE (*((short *)MK_FP(0x40, 0x63)))

#define _wait_(ID,VAL)  \
w_##ID##1:              \
  asm in    al, dx;     \
  asm test  al, VAL;    \
  asm jne   w_##ID##1;  \
w_##ID##2:              \
  asm in    al, dx;     \
  asm test  al, VAL;    \
  asm je    w_##ID##2

#define wait_horizontal(ID,port)  do { _DX=(port); _wait_(ID##ch,8);} while(0)
#define wait_vertical(ID,port)    do { _DX=(port); _wait_(ID##cv,1);} while(0)

#endif

#ifdef __GNUC__
#include <libbcc.h>
extern int kbhit(void);
extern int getkey(void);
#define getch getkey
#define TickTime 838.1e-9

#define init_timer() do { \
  asm volatile( "       \n\
     movb $0x34, %%al   \n\
     outb %%al, $0x43   \n\
     xorb %%al, %%al    \n\
     outb %%al, $0x40   \n\
     outb %%al, $0x40    "\
     : /* nothing */      \
     : /* nothing */      \
     : "ax"               \
  );                      \
} while(0)


#define ReadTimer() ({                    \
  register short __rt_res__ asm("%eax");  \
  asm volatile ( "                      \n\
    movb   $4, %%al                     \n\
    outb   %%al, $0x43                  \n\
    inb    $0x40, %%al                  \n\
    movb   %%al, %%bl                   \n\
    inb    $0x40, %%al                  \n\
    movb   %%al, %%ah                   \n\
    movb   %%bl, %%al                   \n\
    notw   %%ax                          "\
    : "=g" (__rt_res__)                   \
    : /* nothing */                       \
    : "bx"                                \
  );                                      \
  (int) __rt_res__;                       \
})

#define CRTC_BASE (*((short *)0xE0000463))

#define disable() asm volatile ("cli")
#define enable()  asm volatile ("sti")


#define __wait__(ID,port,val)  \
  asm volatile("             \n\
    movl  %0, %%edx          \n\
_w_"#ID"1:                   \n\
    inb   %%dx, %%al         \n\
    testb %1, %%al           \n\
    jne   _w_"#ID"1          \n\
_w_"#ID"2:                   \n\
    inb   %%dx, %%al         \n\
    testb %1, %%al           \n\
    je    _w_"#ID"2           "\
    : /* NOTHING */            \
    : "g" (port), "g" (val)    \
    : "ax", "dx"               \
  )

#define wait_horizontal(ID,port)  __wait__(WH_##ID,port,8)
#define wait_vertical(ID,port)    __wait__(WV_##ID,port,1)

#endif

#define NEXT_TXT "Hit any key"

double measure_vertical(int mono)
{
  short start, stop;
  int   count;
  long  sum = 0;
  long  diff;

  if (mono) mono = 0x3ba; else mono = 0x3da;
  for (count = 0; count < 20; ) {
    disable();
    init_timer();
    wait_horizontal(v1,mono);
    start = ReadTimer();
    wait_horizontal(v2,mono);
    stop = ReadTimer();
    enable();
    diff = stop-start;
    if (diff < 0) diff += 65536L;
    sum += diff;
    ++count;
    if (kbhit()) break;
  }
  return 1/(TickTime*((double)sum) / ((double) count));
}

double measure_horizontal(int mono)
{
  short start, stop;
  int   count;
  long  sum = 0;
  long  diff;

  if (mono) mono = 0x3ba; else mono = 0x3da;
  for (count = 0; count < 20; ) {
    disable();
    init_timer();
    wait_horizontal(mv0,mono);
    wait_vertical(mv0,mono);
    start = ReadTimer();
    wait_vertical(mv1,mono);
    wait_vertical(mv2,mono);
    wait_vertical(mv3,mono);
    wait_vertical(mv4,mono);
    wait_vertical(mv5,mono);
    wait_vertical(mv6,mono);
    wait_vertical(mv7,mono);
    wait_vertical(mv8,mono);
    wait_vertical(mv9,mono);
    wait_vertical(mv10,mono);
    wait_vertical(mv11,mono);
    wait_vertical(mv12,mono);
    wait_vertical(mv13,mono);
    wait_vertical(mv14,mono);
    wait_vertical(mv15,mono);
    stop = ReadTimer();
    enable();
    diff = stop-start;
    if (diff < 0) diff += 65536L;
    sum += diff;
    ++count;
    if (kbhit()) break;
  }
  return 15/(TickTime*((double)sum) / ((double) count));
}


void main(void)
{
  int    gd, gm, gres;
  int    fst, lst;
  int    xp, key;
  char   res[100], mode[100], *verttxt;
  double vertical, horizontal;

  puts("This program measures the vertical and horizontal frequencies");
  puts("in ALL available graphics modes.");
  puts("Skip a mode by <return> and abort the program by <ESC>");
  printf("\nPress any key to continue ...");
  fflush(stdout);
  if (getch() == 27) return;
  gd = DETECT;
  initgraph( &gd, &gm, "c:\\bc\\bgi");
  gres = graphresult();
  if (gres != grOk) {
    fprintf(stderr, "Couldn't initialize graphics!\n");
    exit( gres);
  }
  if (gd != VGA) {
    closegraph();
    fprintf( stderr, "Need VGA card!\n");
    exit(1);
  }
  getmoderange( gd, &fst, &lst);
  for (gm = fst; gm <= lst; ++gm) {
    restorecrtmode();
    printf( "Ready for %s graphics mode (<SPACE> skips) ?", getmodename(gm));
    fflush(stdout);
    key = getch();
    if (key == ' ') continue;
    if (key == 27)  break;
    setgraphmode( gm);
#ifdef __GNUC__
    if (gm >= __FIRST_DRIVER_SPECIFIC_MODE)
      res[0] = '\0';
    else
#endif
      sprintf( res," (%d x %d x %d)",getmaxx()+1,getmaxy()+1,getmaxcolor()+1);
    sprintf(mode,"Mode %d: %s%s",  gm, getmodename(gm), res);
    rectangle( 0, 0, getmaxx(), getmaxy());
    rectangle( 50, 50, getmaxx()-50, getmaxy()-50);
    line( 50, 50, getmaxx()-50, getmaxy()-50);
    line( 50, getmaxy()-50, getmaxx()-50, 50);
    outtextxy( 10, 18, mode);
    vertical = measure_vertical(CRTC_BASE < 0x3d4);
    horizontal = measure_horizontal(CRTC_BASE < 0x3d4);
    verttxt = ((horizontal/(getmaxy()*vertical)<1.0) ? ", (interlaced)" : "");
    moveto( 10, getmaxy()-30);
    sprintf( res, "Vertical frequency   : %4.1fHz%s", vertical, verttxt);
    outtext(res);
    moveto( 10, getmaxy()-10);
    sprintf( res, "Horizontal frequency : %4.2fKHz", horizontal / 1000.0);
    outtext(res);
    xp = getmaxx()-strlen(NEXT_TXT)*8;
    bar(xp-10, 0, getmaxx(),12);
    setcolor(BLACK);
    outtextxy(xp-5, 3, NEXT_TXT);
    setcolor(WHITE);
    if ( getch() == 27) break;
  }
  closegraph();
}
