#define set_readkey(c) ({ ch = (c); return '\0';})

#ifdef __linux__
#   include <gppconio.h>
#else
#  include <pc.h>
#endif
#include <p2c/tasten.h>

char ReadKey(void)
{
  static char ch = '\0';
	 char res;
	 int  key;

  if (ch != '\0') {
    res = ch;
    ch = '\0';
    return res;
  }
  do {
    switch (key=getkey()) {
      case F1        : set_readkey('\x3B');
      case F2        : set_readkey('\x3C');
      case F3        : set_readkey('\x3D');
      case F4        : set_readkey('\x3E');
      case F5        : set_readkey('\x3F');
      case F6        : set_readkey('\x40');
      case F7        : set_readkey('\x41');
      case F8        : set_readkey('\x42');
      case F9        : set_readkey('\x43');
      case F10       : set_readkey('\x44');
      case sF1       : set_readkey('\x54');
      case sF2       : set_readkey('\x55');
      case sF3       : set_readkey('\x56');
      case sF4       : set_readkey('\x57');
      case sF5       : set_readkey('\x58');
      case sF6       : set_readkey('\x59');
      case sF7       : set_readkey('\x5A');
      case sF8       : set_readkey('\x5B');
      case sF9       : set_readkey('\x5C');
      case sF10      : set_readkey('\x5D');
      case cF1       : set_readkey('\x5E');
      case cF2       : set_readkey('\x5F');
      case cF3       : set_readkey('\x60');
      case cF4       : set_readkey('\x61');
      case cF5       : set_readkey('\x62');
      case cF6       : set_readkey('\x63');
      case cF7       : set_readkey('\x64');
      case cF8       : set_readkey('\x65');
      case cF9       : set_readkey('\x66');
      case cF10      : set_readkey('\x67');
      case aF1       : set_readkey('\x68');
      case aF2       : set_readkey('\x69');
      case aF3       : set_readkey('\x6A');
      case aF4       : set_readkey('\x6B');
      case aF5       : set_readkey('\x6C');
      case aF6       : set_readkey('\x6D');
      case aF7       : set_readkey('\x6E');
      case aF8       : set_readkey('\x6F');
      case aF9       : set_readkey('\x70');
      case aF10      : set_readkey('\x71');
      case alt_Q     : set_readkey('\x10');
      case alt_W     : set_readkey('\x11');
      case alt_E     : set_readkey('\x12');
      case alt_R     : set_readkey('\x13');
      case alt_T     : set_readkey('\x14');
      case alt_Z     : set_readkey('\x15');
      case alt_U     : set_readkey('\x16');
      case alt_I     : set_readkey('\x17');
      case alt_O     : set_readkey('\x18');
      case alt_P     : set_readkey('\x19');
      case alt_A     : set_readkey('\x1E');
      case alt_S     : set_readkey('\x1F');
      case alt_D     : set_readkey('\x20');
      case alt_F     : set_readkey('\x21');
      case alt_G     : set_readkey('\x22');
      case alt_H     : set_readkey('\x23');
      case alt_J     : set_readkey('\x24');
      case alt_K     : set_readkey('\x25');
      case alt_L     : set_readkey('\x26');
      case alt_Y     : set_readkey('\x2C');
      case alt_X     : set_readkey('\x2D');
      case alt_C     : set_readkey('\x2E');
      case alt_V     : set_readkey('\x2F');
      case alt_B     : set_readkey('\x30');
      case alt_N     : set_readkey('\x31');
      case alt_M     : set_readkey('\x32');
      case INS       : set_readkey('\x52');
      case HOME      : set_readkey('\x47');
      case PGUP      : set_readkey('\x49');
      case DEL       : set_readkey('\x53');
      case ENDE      : set_readkey('\x4F');
      case PGDN      : set_readkey('\x51');
/*    case sINS      : set_readkey('\x05');  */
/*    case sDEL      : set_readkey('\x07');  */
      case cINS      : set_readkey('\x04');
      case cHOME     : set_readkey('\x77');
      case cPGUP     : set_readkey('\x84');
      case cDEL      : set_readkey('\x06');
      case cENDE     : set_readkey('\x75');
      case cPGDN     : set_readkey('\x76');
      case UP        : set_readkey('\x48');
      case LEFT      : set_readkey('\x4B');
      case DOWN      : set_readkey('\x50');
      case RGHT      : set_readkey('\x4D');
      case cLEFT     : set_readkey('\x73');
      case cRGHT     : set_readkey('\x74');
      case sTAB      : set_readkey('\x0F');
      default        : if (key < 256)
			 return (char) key;
    }
  } while (1);
}

