/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  see bccgrx.c for details
 *
 *
 *  This random number generator should be compatible
 *  with the Turbo-Pascal random(..) function
 *
 */

#include <p2c/tp_port.h>

long RANDSEED_TP;
unsigned short RANDOM_TP(unsigned short range)
{
  RANDSEED_TP = RANDSEED_TP * 134775813L + 1;
  if (range == 0) return 0;
  return (((unsigned long)RANDSEED_TP) >> 16) % range;
}

#ifdef __linux__
#include <sys/time.h>
  void RANDZE_TP(void)
  {
    long temp;
    struct timeval tv;
    struct timezone tz;

    gettimeofday( &tv, &tz);
    temp = tv.tv_sec*1000000 + tv.tv_usec;
    temp ^= (temp >> 16);
    temp ^= (temp << 10);
    RANDSEED_TP = temp;
  } 

#else

#  define TIMER_LOW  ((unsigned short *) 0xE000046C)
#  define TIMER_HIGH ((unsigned short *) 0xE000046E)
  void RANDZE_TP(void)
  {
    RANDSEED_TP = *TIMER_LOW + (*TIMER_HIGH << 16);
  }
#endif

double RANDOM_R_TP(void) {
  RANDOM_TP( 1);
  return (double)((unsigned long) RANDSEED_TP) / 4294967296.0;
}
