/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  see bccgrx.c for details
 */

#include "bccgrx00.h"
#include <stdio.h>

#define NRCOLS(nr) ((((nr)&0xc000)!=0xc000) ? (nr) : (1 << ((nr) & 0xff)))

char *getmodename(int mode_number)
{
  GR_DRIVER_MODE_ENTRY *gm;
  static char result[30];

  _DO_INIT_CHECK_RV(NULL);
  __gr_set_up_modes();
  if (mode_number < 0 || mode_number > MM) {
    ERR = grInvalidMode;
    return NULL;
  }
  switch (mode_number) {
    case GRX_DEFAULT_GRAPHICS               : return "default graphics mode";
    case GRX_BIGGEST_NONINTERLACED_GRAPHICS : return "biggest non interlaced graphics mode";
    case GRX_BIGGEST_GRAPHICS               : return "biggest graphics mode";
    case GRX_BGI_EMULATION                  : return "BGI emulation mode";
  }
  gm = &__gr_DATA[__gr_modeindx[mode_number]];
  sprintf(result, "%d x %d x %d", gm->width,
				  gm->height,
				  NRCOLS(gm->number_of_colors));
  return result;
}

