/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  see bccgrx.c for details
 */


#include "bccgrx00.h"

/*
   - Take care : Borland C defines polypoints as int * but
   -             assumes struct pointtype *  .
   -             GRX requires int points[][2] !
   - The good news are : Both definitions are compatible !
*/

void fillpoly(int numpoints, void *polypoints)
{
  void *cpp;

  _DO_INIT_CHECK;
  if (VL != 0 || VT != 0) {
    int i, *ppd, *pps;

    pps = polypoints;
    ppd = cpp = alloca( sizeof(int) * 2 * numpoints);
    if (cpp==NULL) {
      ERR = grNoScanMem;
      return;
    }
    for (i=0; i < numpoints; ++i) {
      *(ppd++) = *(pps++) + VL;
      *(ppd++) = *(pps++) + VT;
    }
  } else
    cpp = polypoints;

  switch (FPATT) {
    case SOLID_FILL :
      GrFilledPolygon(numpoints, cpp, FILL);
      if (COL != FILL)
	__gr_drawpoly(numpoints, polypoints, TRUE);
      break;
    case EMPTY_FILL :
      GrFilledPolygon(numpoints, cpp, COLBG);
      if (COL != COLBG)
	__gr_drawpoly(numpoints, polypoints, TRUE);
      break;
    default :
      FILLP.gp_bmp_fgcolor = FILL;
      FILLP.gp_bmp_bgcolor = COLBG;
      GrPatternFilledPolygon( numpoints, cpp, &FILLP);
      __gr_drawpoly( numpoints, polypoints, TRUE);
      break;
  }
}
