/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  see bccgrx.c for details
 */

#include "bccgrx00.h"

void set_BGI_mode(int *graphdriver, int *graphmode)
{
  int rx = 0;
  int ry = 0;
  int rc = 0;

  switch (*graphdriver) {
    case VGA     : switch (*graphmode) {
		     case VGALO : rx = 640; ry = 480; rc = 256; break;
		     case VGAMED: rx = 800; ry = 600; rc = 256; break;
		     case VGAHI : rx = 1024; ry = 768; rc = 256; break;
		   }
		   break;
    case IBM8514 : switch (*graphmode) {
		     case IBM8514LO: rx =  640; ry = 480; rc = 256; break;
		     case IBM8514HI: rx = 1024; ry = 768; rc = 256; break;
		   }
		   break;
    case HERCMONO: if (*graphmode == HERCMONOHI) {
		     rx = 720;
		     ry = ((__gr_ADAPTER == GR_HERC) ? 348 : 350);
		     rc = ((__gr_ADAPTER == GR_HERC) ?   2 :  16);
		   }
		   break;
    case CGA     :
    case MCGA    :
    case ATT400  : switch (*graphmode) {
		     case CGAC0 :
		     case CGAC1 :
		     case CGAC2 :
		     case CGAC3 : rx = 320; ry = 200;            break;
		     case CGAHI : /* == MCGAMED == ATT400MED */
				  rx = 640; ry = 200;            break;
		     case MCGAHI: /* == ATT400HI */
				  switch (*graphdriver) {
				    case MCGA  : rx = 640; ry = 480; break;
				    case ATT400: rx = 640; ry = 400; break;
				  }
				  break;
		   }
		   rc = 16;
		   break;
    case EGA64   : switch (*graphmode) {
		     case EGA64LO : rx = 640; ry = 200; rc = 16;     break;
		     case EGA64HI : rx = 640;
				    ry = 350;
				    rc = ((__gr_ADAPTER == GR_EGA) ? 4 : 16);
				    break;
		   }
		   break;
    case EGA     : switch (*graphmode) {
		     case EGALO : rx = 640; ry = 200; rc = 16;       break;
		     case EGAHI : rx = 640; ry = 350; rc = 16;       break;
		   }
		   break;
    case EGAMONO : if (*graphmode == EGAMONOHI) {
		     rx = 640; ry = 350; rc = 16;
		   }
		   break;
    case PC3270  : if (*graphmode == PC3270HI) {
		     rx = 720; ry = 350; rc = 16;
		   }
		   break;
    default      : ERR = grInvalidDriver;
		   return;
  }

  if (rx != 0) {
    __gr_BGI_w = rx;
    __gr_BGI_h = ry;
    __gr_BGI_c = rc;
    *graphdriver = NATIVE_GRX;
    *graphmode   = GRX_BGI_EMULATION;
  } else
    ERR = grInvalidMode;
}
