/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  see bccgrx.c for details
 */

#ifndef __BCCGRX00_H
#define __BCCGRX00_H

#define HOLD_GR_DEFS

#include <stddef.h>
#include <grx.h>
#include <grdriver.h> 
#ifdef __linux__
#  undef VGA
#endif
#include "../include/bccgrx.h"

/* --- from grx/genellipse : */

extern int _grx_arc_xc, _grx_arc_yc,
	   _grx_arc_xs, _grx_arc_ys,
	   _grx_arc_xe, _grx_arc_ye;

/* --- from bccgrx.c : */

extern GrLineOption          __gr_Line;
extern short                *__gr_modeindx;
extern GR_DRIVER_MODE_ENTRY *__gr_DATA;
extern GrContext            *__gr_viewport;
extern char                  __gr_BGICHR[];

/* ------------------------- */

#define ERR    __gr_Result
#define MM     __gr_MaxMode
#define X      __gr_X
#define Y      __gr_Y
#define LNE    __gr_Line
#define LNEP   __gr_LineP
#define COL    __gr_color
#define COLBG  __gr_colorbg
#define FILL   __gr_colorfill
#define WR     __gr_WR
#define FPATT  __gr_fpatno
#define FILLP  __gr_fillpattern
#define VL     __gr_vpl
#define VR     __gr_vpr
#define VT     __gr_vpt
#define VB     __gr_vpb

#define WIDTH  (__gr_vpr-__gr_vpl+1)
#define HEIGHT (__gr_vpb-__gr_vpt+1)
#define SWAP(a,b) ({typeof(a) tmp; tmp = a; a = b; b = tmp;})

#define _DO_INIT_CHECK ({if (!__gr_INIT) {__gr_Result=grNoInitGraph;return;}})
#define _DO_INIT_CHECK_RV(rv) ({if (!__gr_INIT) { __gr_Result = grNoInitGraph;\
						  return (rv);}})

/* ----------------------------------------------------------------- */
__inline__ static void __gr_Reset_ClipBox(void)
{
  if (__gr_clip) GrSetClipBox( VL, VT, VR, VB);
	    else GrResetClipBox();
}


#endif
