/* Header for module Dos, generated by p2c */
#ifndef DOS_H
#define DOS_H

#include <errno.h>

#ifdef DOS_G
# define vextern
#else
# define vextern extern
#endif


/* String types */
/* Used in filename/command line processing */
typedef char ComStr[2049];   /* Command line string */
typedef char PathStr[257];   /* Full file path string */
typedef char DirStr[257];    /* Drive and directory string */
typedef char NameStr[257];   /* File name string */
typedef char ExtStr[257];    /* File extension string */

/* Date and time record used by PackTime and UnpackTime */

typedef struct DateTime {
  unsigned short Year, Month, Day, Hour, Min, Sec;
} DateTime;

/* Error status variable */
vextern int DosError;

extern void GetDate(unsigned short *Year, unsigned short *Month,
		    unsigned short *Day, unsigned short *DayOfWeek);
extern void GetTime(unsigned short *Hour, unsigned short *Minute,
		    unsigned short *Second, unsigned short *Sec100);
extern void UnpackTime(long p, DateTime *t);
extern void PackTime(DateTime *t, long *p);
extern void SwapVectors(void); 
extern void Exec(char *Path, char *ComLine);
extern unsigned short DosExitCode(void);
extern char *FExpand(char *Result, char *Path);
extern void FSplit(char *Path, char *Dir, char *Name, char *Ext);

/* some homeless orphans */
extern void RmDir( char * Directory);
extern void ChDir( char * Directory);
extern void MkDir( char * Directory);
extern int  GetDir(int drv, char *dir);
/* GetEnv is a funcmacro  */

/* ----------------------------------------------------------- un supported ----- */

/* Flags bit masks */
/*
#define FCarry          0x1
#define FParity         0x4
#define FAuxiliary      0x10
#define FZero           0x40
#define FSign           0x80
#define FOverflow       0x800
*/
/* File mode magic numbers */
/*
#define fmClosed        0xd7b0L
#define fmInput         0xd7b1L
#define fmOutput        0xd7b2L
#define fmInOut         0xd7b3L
*/
/* File attribute constants */
/*
#define ReadOnly        0x1
#define Hidden          0x2
#define SysFile         0x4
#define VolumeID        0x8
#define Directory       0x10
#define Archive         0x20
#define AnyFile         0x3f
*/

/* Registers record used by Intr and MsDos */
/*
typedef union Registers {
  struct {
    unsigned short AX, BX, CX, DX, BP, SI, DI, DS, ES, Flags;
  } U0;
  struct {
    uchar AL, AH, BL, BH, CL, CH, DL, DH;
  } U1;
} Registers;
*/
/* Typed-file and untyped-file record */
/*
typedef struct FileRec {
  unsigned short Handle, Mode, RecSize;
  uchar Private[26];
  uchar UserData[16];
  char Name[80];
} FileRec;
*/
/* Textfile record */
/*
typedef char TextBuf[128];

typedef struct TextRec {
  unsigned short Handle, Mode, BufSize, Private, BufPos, BufEnd;
  char *BufPtr;
  void *OpenFunc, *InOutFunc, *FlushFunc, *CloseFunc;
  uchar UserData[16];
  char Name[80];
  TextBuf Buffer;
} TextRec;
*/
/* Search record used by FindFirst and FindNext */
/*
typedef struct SearchRec {
  uchar Fill[21];
  uchar Attr;
  long Time, Size;
  char Name[257];
} SearchRec;
*/

/* function DosVersion: Word; */
/* procedure Intr(IntNo: Byte; var Regs: Registers); */
/* procedure MsDos(var Regs: Registers); */
/* procedure SetDate(Year,Month,Day: Word); */
/* procedure SetTime(Hour,Minute,Second,Sec100: Word); */
/* extern void GetCBreak(boolean *Break); */
/* extern void SetCBreak(boolean Break);  */
/* procedure GetVerify(var Verify: Boolean); */
/* procedure SetVerify(Verify: Boolean); */
/* function DiskFree(Drive: Byte): Longint; */
/* function DiskSize(Drive: Byte): Longint; */
/* extern void GetFAttr(void *F, unsigned short *Attr); */
/* extern void SetFAttr(void *F, unsigned short Attr);  */
/* extern void GetFTime(void *F, long *Time); */
/* extern void SetFTime(void *F, long Time); */
/* extern void FindFirst(char *Path, unsigned short Attr, SearchRec *F); */
/* extern void FindNext(SearchRec *F); */
/* procedure GetIntVec(IntNo: Byte; var Vector: Pointer); */
/* procedure SetIntVec(IntNo: Byte; Vector: Pointer); */
/* extern void Keep(unsigned short ExitCode); */
/* extern char *FSearch(char *Result, char *Path, char *DirList); */
/* extern int EnvCount(void); */
/* extern char *EnvStr(char *Result, int Index); */

#undef vextern

#endif /*DOS_H*/


