#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <p2c/p2c.h> 
#include <sys/time.h>
#include "lnxconio.h"
#define DOS_G
#include "lnxdos.h"

/* Unit DOS */

static void my_strcpy(char *dst, char *src)
{
  if (src != NULL) {
    if (*src != '\0' && src[1] == ':') /* Kill drive */
      src+=2; 
    while (*src != '\0') {
      if (*src == '\\') { *(dst++) = '/'; ++src; }
	           else { *(dst++) = *(src++);   }
    }
  }
  *dst = '\0';
}

static void my_strcat(char *dst, char *src)
{
  while (*dst != '\0') ++dst;
  my_strcpy(dst, src);
}

int GetDir(int drv, char *VarName )
{	
	DirStr dir;
        if(!getcwd( dir,sizeof(DirStr)-1)) {
		*VarName = '\0';
		return (P_ioresult = 2); /* should never happen...*/
	} else {
		my_strcpy(VarName,dir);
		return 0;
	}
}   

void FSplit( char *FName, char * Path, char * Name, char * Ext )
{
	char *ptr;
	char *name;
	char *Pathh = NULL;
	char *Namee = NULL;
	char *Extt  = NULL;

	name = alloca(strlen(FName)+1);
	my_strcpy(name, FName);

	ptr = (char *) strrchr(name, '/');
	if (ptr != NULL) {
	  *ptr  = '\0';
	  Pathh = name;
	  name  = ptr+1;
        }	  

	Namee = name;
	ptr = (char *) strrchr(name, '.');
	if (ptr != NULL) {
	  *ptr = '\0';
	  Extt = ptr+1;
	}

	my_strcpy(Path, Pathh);
	my_strcpy(Name, Namee);
	my_strcpy(Ext,  Extt);
}

void RmDir( char * Directory)
{
  char *dir;

  dir = alloca(strlen(Directory)+1);
  my_strcpy(dir, Directory);
  if (rmdir(dir)) P_ioresult = 3;
	     else P_ioresult = 0;
}

#define MODE (S_IRWXU|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH)
void MkDir( char * Directory)
{
  char *dir;

  dir = alloca(strlen(Directory)+1);
  my_strcpy(dir, Directory);
  if (mkdir(dir,MODE)) P_ioresult = 5;
		  else P_ioresult = 0;
}
#undef MODE

void ChDir( char * Directory)
{
  char *dir;

  dir = alloca(strlen(Directory)+1);
  my_strcpy(dir, Directory);
  if (chdir(dir)) P_ioresult = 3;
	     else P_ioresult = 0;	
}

static unsigned short _DosExitCode = 0;
void Exec(char *Path, char *ComLine)
{
  char *SysCallStr;
  
  SysCallStr= alloca(strlen(Path)+strlen(ComLine)+2);

  my_strcpy(SysCallStr, Path);
  my_strcat(SysCallStr, " ");
  my_strcat(SysCallStr, ComLine);

  if ((_DosExitCode = system(SysCallStr))) 
    switch (errno) {
      case ENOENT:  DosError= 2; break;
      case ENOEXEC: DosError=11; break;
      case ENOMEM:  DosError= 8; break;
      case EPERM:
      case EACCES:  DosError= 5; break;
      default :     DosError= 0; break;
    }
}

unsigned short DosExitCode(void)
{
  return _DosExitCode;
}

void SwapVectors(void){ /* doing nothing */ }

char *FExpand(char *Result, char *Path)
{
  char *path;

  path = alloca(strlen(Path)+1);
  my_strcpy(path, Path);

  if ( strchr(path, '/') != 0) {
    strcpy(Result, path);
  } else {
    GetDir(0,Result);
    my_strcat(Result, "/");
    strcat(Result, path);
  }
  return Result;
}

void GetDate(unsigned short *Year, unsigned short *Month,
	     unsigned short *Day, unsigned short *DayOfWeek)
{
  time_t et;
  struct tm *st;

  et = time(NULL);
  st = gmtime(&et);
  *Year      = st->tm_year + 1900;
  *Month     = st->tm_mon + 1;  /* Why this ?? */
  *Day       = st->tm_mday;
  *DayOfWeek = st->tm_wday;
}

void GetTime(unsigned short *Hour, unsigned short *Minute,
	     unsigned short *Second, unsigned short *Sec100)
{
  struct timeval tv;
  long secs;

  gettimeofday(&tv, NULL);
  *Sec100 = tv.tv_usec/10000;
  secs = tv.tv_sec;
  *Second = secs % 60;  secs /= 60;
  *Minute = secs % 60;  secs /= 60;
  *Hour   = secs % 24;
}

void UnpackTime(long p, DateTime *t)
{
  t->Sec   = (p & 0x1F) * 2;  p >>= 5;
  t->Min   = (p & 0x3F);      p >>= 6;
  t->Hour  = (p & 0x1F);      p >>= 5;
  t->Day   = (p & 0x1F);      p >>= 5;
  t->Month = (p & 0x0F);      p >>= 4;
  t->Year  = (p & 0x7F)+1980;
}

void PackTime(DateTime *t, long *p)
{
  long res;

              res  = ((t->Year-1980) & 0x7F);
  res <<= 4;  res |= (t->Month       & 0x0F);
  res <<= 5;  res |= (t->Day         & 0x1F);
  res <<= 5;  res |= (t->Hour        & 0x1F);
  res <<= 6;  res |= (t->Min         & 0x3F);
  res <<= 5;  res |= ((t->Sec/2)     & 0x1F);
  *p = res;
}

