#include <stdio.h>
#include <stdlib.h>
#ifdef __GNUC__
#  define __WINCONIO
#  include <Grx/gppconio.h>
#else
#  include <conio.h>
#endif


struct text_info ti;
#define WDT ((int)ti.winright-ti.winleft+1)
#define HGT ((int)ti.winbottom-ti.wintop+1)

void test_gettextinfo(void)
{
   gettextinfo(&ti);
   cprintf("window left      %3d\n",(int)ti.winleft);
   cprintf("window top       %3d\n",(int)ti.wintop);
   cprintf("window right     %3d\n",(int)ti.winright);
   cprintf("window bottom    %3d\n",(int)ti.winbottom);
   cprintf("attribute        %3d\n",(int)ti.attribute);
   cprintf("normal attribute %3d\n",(int)ti.normattr);
   cprintf("current mode     %3d\n",(int)ti.currmode);
   cprintf("screen height    %3d\n",(int)ti.screenheight);
   cprintf("screen width     %3d\n",(int)ti.screenwidth);
   cprintf("current x        %3d\n",(int)ti.curx);
   cprintf("current y        %3d\n",(int)ti.cury);
   if (getch() == 27) exit(1);
}

void testscr(int fill)
{
  int x, y;

  gotoxy(1,1);
  for (y=0; y < HGT; ++y) {
    cprintf("%3d  ", y+1);
    for (x=5; x < WDT; ++x) {
      if (x == WDT-1 && y == HGT-1) break;
      if (fill && y!=0) putch('"');
	           else putch('0'+((x+1)%10));
    }
  }
}

void GOTOXY(int x,int y)
{
  gotoxy(x,y);
  if (wherex() != x || wherey() != y) {
    printf("\nx=%d, wherex()=%d,  y=%d, wherey()=%d\n",x,wherex(),y,wherey());
    exit(1);
  }
}

void test_gotoxy(void)
{
  testscr(0);
  GOTOXY(10,5);
  if (getch() == 27) exit(1);
  GOTOXY(10,10);
  if (getch() == 27) exit(1);
  GOTOXY(20,10);
  if (getch() == 27) exit(1);
  GOTOXY(WDT,1);
  if (getch() == 27) exit(1);
  GOTOXY(1,HGT);
  if (getch() == 27) exit(1);
  GOTOXY(WDT,HGT);
  if (getch() == 27) exit(1);
}

void test_clreol(void)
{
  testscr(0);
  GOTOXY(10,5);
  clreol();
  if (getch() == 27) exit(1);
  GOTOXY(WDT,10);
  clreol();
  if (getch() == 27) exit(1);
  GOTOXY(WDT,HGT);
  clreol();
  if (getch() == 27) exit(1);
}

void test_delline(void)
{
  testscr(0);
  GOTOXY(1,1);
  delline();
  if (getch() == 27) exit(1);
  testscr(0);
  GOTOXY(WDT,1);
  delline();
  if (getch() == 27) exit(1);
  testscr(0);
  GOTOXY(1,HGT);
  delline();
  if (getch() == 27) exit(1);
  testscr(0);
  GOTOXY(WDT,HGT);
  delline();
  if (getch() == 27) exit(1);
}

void test_insline(void)
{
  testscr(0);
  GOTOXY(1,1);
  insline();
  if (getch() == 27) exit(1);
  testscr(0);
  GOTOXY(WDT,1);
  insline();
  if (getch() == 27) exit(1);
  testscr(0);
  GOTOXY(1,HGT);
  insline();
  if (getch() == 27) exit(1);
  testscr(0);
  GOTOXY(WDT,HGT);
  insline();
  if (getch() == 27) exit(1);
}

void test_clrscr(void)
{
  testscr(0);
  clrscr();
  if (getch() == 27) exit(1);
}

void test_hilovideo(int keep_high)
{
  highvideo();
  testscr(0);
  if (getch() == 27) exit(1);
  lowvideo();
  testscr(0);
  if (getch() == 27) exit(1);
  if (keep_high) {
    highvideo();
    testscr(0);
  }
  normvideo();
}


void attr_scr(void)
{
   int x, y;

   clrscr();
   for (y=0; y < 16; ++y) {
     for (x=0; x < 16; ++x) {
       textattr( x+(y<<4));
       cprintf("%2d%2d",x,y);
     }
     normvideo();
     cprintf("\r\n");
   }
}

void test_attr(void)
{
   attr_scr();
   if (getch() == 27) exit(1);
}

void test_getput(void)
{
   void *save;

   attr_scr();
   save = (void *) malloc(2*((int)ti.screenheight)*((int)ti.screenwidth));
   if (save != NULL) {
     gettext(ti.winleft,ti.wintop,ti.winright,ti.winbottom,save);
     if (getch() == 27) exit(1);
     clrscr();
     gotoxy(1,ti.winbottom);
     if (getch() == 27) exit(1);
     puttext(ti.winleft,ti.wintop,ti.winright,ti.winbottom,save);
     if (getch() == 27) exit(1);
   }
}

struct text_info nw;

static void redraw(void)
{
   int x, y;

   clrscr();
   for (y=ti.wintop; y <=ti.winbottom; ++y) {
     cprintf("%3d  ", y);
     for (x=ti.winleft+5; x<= ti.winright; ++x)
       if (x!=ti.winright || y!=ti.winbottom)
	 putch('0'+((x+y)%10));
   }
   window(nw.winleft, nw.wintop, nw.winright, nw.winbottom);
   clrscr();
   textcolor(RED);
   textbackground(GREEN);
   for (y=nw.wintop; y <=nw.winbottom; ++y) {
     cprintf("%3d  ", y);
     for (x=nw.winleft+5; x<= nw.winright; ++x)
       if (x!=nw.winright || y!=nw.winbottom)
	 putch('A'+(x%26));
   }
   window(ti.winleft, ti.wintop, ti.winright, ti.winbottom);
   normvideo();
}

void test_move(void)
{
   int rows, cols, ox, oy;

   rows = (ti.winbottom-ti.wintop) / 2;
   cols = (ti.winright-ti.winleft) / 2;
   oy   = ((ti.winbottom-ti.wintop) - rows) / 2;
   ox   = ((ti.winright-ti.winleft) - cols) / 2;
   window(ti.winleft+ox,ti.wintop+oy, ti.winleft+ox+cols-1, ti.wintop+oy+rows-1);
   gettextinfo(&nw);
   window(ti.winleft, ti.wintop, ti.winright, ti.winbottom);
   redraw();
   if (getch() == 27) exit(1);

   movetext(nw.winleft, nw.wintop, nw.winright, nw.winbottom, 1, 1);
   getch();

   redraw();
   movetext(nw.winleft, nw.wintop, nw.winright, nw.winbottom, nw.winleft-1, nw.wintop);
   if (getch() == 27) exit(1);
   redraw();
   movetext(nw.winleft, nw.wintop, nw.winright, nw.winbottom, nw.winleft, nw.wintop-1);
   if (getch() == 27) exit(1);
   redraw();
   movetext(nw.winleft, nw.wintop, nw.winright, nw.winbottom, nw.winleft+1, nw.wintop);
   if (getch() == 27) exit(1);
   redraw();
   movetext(nw.winleft, nw.wintop, nw.winright, nw.winbottom, nw.winleft, nw.wintop+1);
   if (getch() == 27) exit(1);
   redraw();
   movetext(nw.winleft, nw.wintop, nw.winright, nw.winbottom,
            ti.screenwidth-cols+1, ti.screenheight-rows+1);
   if (getch() == 27) exit(1);
}


void main(void)
{
  _setcursortype(_NORMALCURSOR);
  test_gettextinfo();
  test_gotoxy();
  test_clreol();
  test_delline();
  test_insline();
  test_clrscr();
  test_getput();
  test_move();
  test_hilovideo(0);
  testscr(1);
  window(10, 5, WDT-10, HGT-5);
  clrscr();
  test_gettextinfo();
  test_gotoxy();
  test_clreol();
  test_delline();
  test_insline();
  test_clrscr();
  test_getput();
  test_move();
  test_hilovideo(1);
  window(1,1,ti.screenwidth,ti.screenheight);
{ int i;
  gotoxy(1, 15);
  for (i=0; i < ti.screenwidth; ++i)
    putch( '0' + (i%10));
  gotoxy(1, 16);
  for (i=0; i < ti.screenwidth; ++i)
    putch( '0' + ((i+2)%10));
}
  gotoxy(1,ti.screenheight);
  clreol();
}

