/* Header for module tasten, generated by p2c */
#ifndef TASTEN_H
#define TASTEN_H

#ifdef TASTEN_G
#  define vextern
#  define vINITIAL(x) =(x)
#else
#  define vextern extern
#  define vINITIAL(x)
#endif
/*  Tasten - Codes wie sie von getch()/getkey() geliefert werden */

/* ------------------- Steuertasten -------------------- */

#define PGUP            0x149 /* Page up */
#define cPGUP           0x184
#define aPGUP           0x199
#define PGDN            0x151 /* Page down */
#define cPGDN           0x176
#define aPGDN           0x1a1
#define HOME            0x147 /* Home */
#define cHOME           0x177
#define aHOME           0x197
#define ENDE            0x14f /* End */
#define cENDE           0x175
#define aENDE           0x19f
#define LEFT            0x14b /* Left */
#define cLEFT           0x173
#define aLEFT           0x19b
#define UP              0x148 /* Up */
#define cUP             0x18d
#define aUP             0x198
#define DOWN            0x150 /* DOWN */
#define cDOWN           0x191
#define aDOWN           0x1a0
#define RGHT            0x14d /* Right */
#define cRGHT           0x174
#define aRGHT           0x19d
#define TAB             0x009 /* TAB */
#define sTAB            0x10f
#define cTAB            0x194
#define aTAB            0x1a5
#define BS              0x008 /* Backspace */
#define cBS             0x07f
#define aBS             0x10e
#define INS             0x152 /* Insert */
#define cINS            0x192
#define aINS            0x1a2
#define DEL             0x153
#define cDEL            0x193
#define aDEL            0x1a3

/* --------------- Funktionstasten ---------------- */
#define F1              0x13b       /* F1 */
#define sF1             0x154
#define cF1             (sF1+10)
#define aF1             (sF1+20)
#define F2              (F1+1)      /* F2 */
#define sF2             (sF1+1)
#define cF2             (cF1+1)
#define aF2             (aF1+1)
#define F3              (F1+2)      /* F3 */
#define sF3             (sF1+2)
#define cF3             (cF1+2)
#define aF3             (aF1+2)
#define F4              (F1+3)      /* F4 */
#define sF4             (sF1+3)
#define cF4             (cF1+3)
#define aF4             (aF1+3)
#define F5              (F1+4)      /* F5 */
#define sF5             (sF1+4)
#define cF5             (cF1+4)
#define aF5             (aF1+4)
#define F6              (F1+5)      /* F6 */
#define sF6             (sF1+5)
#define cF6             (cF1+5)
#define aF6             (aF1+5)
#define F7              (F1+6)      /* F7 */
#define sF7             (sF1+6)
#define cF7             (cF1+6)
#define aF7             (aF1+6)
#define F8              (F1+7)      /* F8 */
#define sF8             (sF1+7)
#define cF8             (cF1+7)
#define aF8             (aF1+7)
#define F9              (F1+8)      /* F9 */
#define sF9             (sF1+8)
#define cF9             (cF1+8)
#define aF9             (aF1+8)
#define F10             (F1+9)      /* F10 */
#define sF10            (sF1+9)
#define cF10            (cF1+9)
#define aF10            (aF1+9)
#define F11             0x185       /* F11 */
#define sF11            (F11+2)
#define cF11            (F11+4)
#define aF11            (F11+6)
#define F12             (F11+1)     /* F12 */
#define sF12            (sF11+1)
#define cF12            (cF11+1)
#define aF12            (aF11+1)

/* ------------------- alt - Codes ------------------ */

#define alt_Q           0x110
#define alt_W           (alt_Q+1)
#define alt_E           (alt_Q+2)
#define alt_R           (alt_Q+3)
#define alt_T           (alt_Q+4)
#define alt_Y           (alt_Q+5)
#define alt_U           (alt_Q+6)
#define alt_I           (alt_Q+7)
#define alt_O           (alt_Q+8)
#define alt_P           (alt_Q+9)

#define alt_A           0x11e
#define alt_S           (alt_A+1)
#define alt_D           (alt_A+2)
#define alt_F           (alt_A+3)
#define alt_G           (alt_A+4)
#define alt_H           (alt_A+5)
#define alt_J           (alt_A+6)
#define alt_K           (alt_A+7)
#define alt_L           (alt_A+8)

#define alt_Z           0x12c
#define alt_X           (alt_Z+1)
#define alt_C           (alt_Z+2)
#define alt_V           (alt_Z+3)
#define alt_B           (alt_Z+4)
#define alt_N           (alt_Z+5)
#define alt_M           (alt_Z+6)

#define alt_1           0x178
#define alt_2           (alt_1+1)
#define alt_3           (alt_1+2)
#define alt_4           (alt_1+3)
#define alt_5           (alt_1+4)
#define alt_6           (alt_1+5)
#define alt_7           (alt_1+6)
#define alt_8           (alt_1+7)
#define alt_9           (alt_1+8)
#define alt_0           (alt_1+9)

/* --------------- Sonstige Tasten ----------------*/

#define ESC             0x01b /* Escape */
#define aESC            0x101
#define RETRN           0x00D /* Return */
#define cRETRN          0x00A
#define aRETRN          0x11c
#define a_nRETRN        0x1a6 /* Return at numpad */
#define c_grPLUS        0x190 /* grey + */
#define a_grPLUS        0x14e
#define c_grMINUS       0x18e /* grey - */
#define a_grMINUS       0x14a
#define c_grMULT        0x196 /* grey * */
#define a_grMULT        0x137
#define c_grDIV         0x195 /* grey / */
#define a_grDIV         0x1a4
#define Num5            0x14c /* 5 at num pad */
#define cNum5           0x18f
#define UE              0x081 /*  */
#define sUE             0x09a
#define aUE             0x11a
#define OE              0x094 /*  */
#define sOE             0x099
#define aOE             0x127
#define AE              0x084 /*  */
#define sAE             0x08e
#define aAE             0x128
#define ES_Z            0x0E1 /*  */
#define aES_Z           0x182
#define aHYPHEN         0x183 /* ' */

#define NoKey           1000   /* unmoeglicher Code   */

vextern int LstGetKey vINITIAL(0);    /* Letzte von GetKey gelieferte Taste */
vextern int NxtGetKey vINITIAL(-1);   /* >= 0 -->> Nchster Wert von GetKey.*/
				      /* Eine Zuweisung an NxtGetKey be-    */
				      /* deutet UnGetKey !                  */

/*------------------------------------------------------------------------*/
/* Zeichen von der Tastatur holen                                         */
extern int GetKey(void);

/*------------------------------------------------------------------------*/
/* Test auf einzelne Tastenklassen                                        */
/* isFKey   TRUE, wenn Key F1..F12 ( ink. Shift, Alt & Cntrl - Varianten) */
extern int isFKey(int Key);

/*------------------------------------------------------------------------*/
/* Gro- / Kleinbuchstaben erzeugen                                       */
extern int KeyUpperCase(int Key);
extern int KeyLowerCase(int Key);
extern unsigned char LowerCase(unsigned char C);
extern unsigned char UpperCase(unsigned char C);

#undef vextern

#endif /*TASTEN_H*/
