#ifndef _CONIO_H
#define _CONIO_H

#include <stdio.h>

#define _NOCURSOR      0
#define _SOLIDCURSOR   1
#define _NORMALCURSOR  2

struct text_info {
    unsigned char winleft;
    unsigned char wintop;
    unsigned char winright;
    unsigned char winbottom;
    unsigned char attribute;
    unsigned char normattr;
    unsigned char currmode;
    unsigned char screenheight;
    unsigned char screenwidth;
    unsigned char curx;
    unsigned char cury;
};

enum text_modes { LASTMODE=-1, BW40=0, C40, BW80, C80, MONO=7, C4350=64 };

#ifndef BLACK
/*  dark colors     */
#define BLACK         0
#define BLUE          1
#define GREEN         2
#define CYAN          3
#define RED           4
#define MAGENTA       5
#define BROWN         6
#define LIGHTGRAY     7
/*  light colors    */
#define DARKGRAY      8
#define LIGHTBLUE     9
#define LIGHTGREEN   10
#define LIGHTCYAN    11
#define LIGHTRED     12
#define LIGHTMAGENTA 13
#define YELLOW       14
#define WHITE        15
#endif

#define BLINK   0x80    /*  blink bit   */

extern   int directvideo;
extern   int _wscroll;

#if defined(__WINCONIO) /* ------------------------------------- */

#ifdef __cplusplus
extern "C" {
#endif

void    clreol(void);
void    clrscr(void);
void	delay(unsigned ms);
void    gotoxy(int x, int y);
int     wherex(void);
int     wherey(void);
int	kbhit(void);
int	ungetch(int ch);
int     putch(int c);
void    window( int left, int top, int right, int bottom);
void    delline(void);
int     gettext(int left, int top, int right, int bottom, void *destin);
void    gettextinfo(struct text_info *r);
void    highvideo(void);
void    insline(void);
void    lowvideo(void);
int     movetext(int left, int top, int right, int bottom, 
            int destleft, int desttop);
void    normvideo(void);
int     puttext(int left, int top, int right, int bottom, void *source);
void    textattr(int attr);
void    textbackground(int color);
void    textcolor(int color);
/* void    textmode(int unused_mode); */
#define textmode(mode) (mode)
void    _setcursortype(int type);
char    *cgets(char *str); 
int     cprintf(const char *format, ...)
          __attribute__((format(printf,1,2)));
int     cputs(const char *str);
int     cscanf(const char *format, ...)
	  __attribute__((format(scanf,1,2)));

/* char    *getpass(const char *prompt); this is in stdlib.h ! */

int  _lnxconio_getch(void);
int  _lnxconio_ungetch(int ch);
int  _lnxconio_system(const char *cmd);
int  _lnxconio_fprintf(FILE *stream, const char *format, ...)
           __attribute__((format(printf,2,3)));
int  _lnxconio_fputc(int c, FILE *stream);
int  _lnxconio_fputs(const char *strg, FILE *stream);

#ifndef __LNXCONIO_C
/* output through curses required */
#undef putchar
#define putchar		putch
#undef putc
#define	putc(c,f)	_lnxconio_fputc((c),(f))
#undef fputc
#define	fputc(c,f)	_lnxconio_fputc((c),(f))
#undef printf
#define printf		cprintf
#undef fprintf
#define fprintf		_lnxconio_fprintf
#undef puts
#define puts		cputs
#undef fputs
#undef fputs		_lnxconio_fputs
/* input also passed through curses */
#undef getch
#define getch		_lnxconio_getch
#undef getkey
#define getkey		_lnxconio_getch
#undef gets
#define gets		cgets
#undef ungetch
#define ungetch(ch)	_lnxconio_ungetch(ch)

#undef system
#define system(cmd)	_lnxconio_system(cmd)
#endif

#ifdef __cplusplus
}
#endif

#else /* -------------------------------------------------- !defined(__WINCONIO) */

void gettextinfo(struct text_info *r);
int  kbhit(void);
int  getkey(void);
int  getch(void);
void textbackground(int color);
void textcolor(int color);
void textattr(int attr);

#define clreol()	({ printf("\033[K"); fflush(stdout); })
#define	clrscr()	({ printf("\033[2J\033[H"); fflush(stdout); })
#define delay(ms)	usleep((ms)*1000)
#define	gotoxy(x,y)	({ printf("\033[%d;%dH", (y), (x)); fflush(stdout); })
#define	putch(c)	({ putchar(c); fflush(stdout); })
#define delline()	({ printf("\r\033[K"); fflush(stdout); })
#define	highvideo()	({ printf("\033[1m"); fflush(stdout); })
#define insline()	({ printf("\r\n"); fflush(stdout); }) 
#define	lowvideo()	({ printf("\033[0m"); fflush(stdout); })
#define	normvideo()	({ printf("\033[0m"); fflush(stdout); })
#define textmode(mode)	(mode)
#define _setcursortype(t) (t)
#define cgets(s)	gets(s)
#define	cprintf(fmt,args...) printf((fmt), ##args)
#define	cputs(s)	puts(s)
#define cscanf(fmt, args...) scanf((fmt), ##args)
/* char    *getpass(const char *prompt); this is in stdlib.h ! */

/* These are noop functions. 
** Use 
**      #define __WINCONIO
**	#include <gppconio.h>
** and link -lconio -lncurses before -lgrx
** if you need one of these
*/
int  wherex(void);
int  wherey(void);
void window(int left, int top, int right, int bottom);
int  gettext(int left, int top, int right, int bottom, void *dst);
int  puttext(int left, int top, int right, int bottom, void *src);
int  movetext(int left, int top, int right, int bottom, int dleft, int dtop);

#endif /* ------------------------------------------------- !defined(__WINCONIO) */

void _lnxconio_clearall(void);

static __inline unsigned char __inportb__(int port)
{
	unsigned char value;
	__asm__ volatile ("inb %1,%0"
		: "=a" (value)
		: "d" ((unsigned short)port));
	return value;
}

static __inline unsigned short __inportw__(int port)
{
	unsigned short value;
	__asm__ volatile ("inw %1,%0"
		: "=a" (value)
		: "d" ((unsigned short)port));
	return value;
}

static __inline void __outportb__( int port, unsigned char value )
{
	__asm__ volatile ("outb %0,%1"
	: : "a" ((unsigned char)value), "d" ((unsigned short)port));
}

static __inline void __outportw__( int port, unsigned short value ) {
	__asm__ volatile("outw %0,%1"
	: : "a" ((unsigned short)value), "d" ((unsigned short)port));
}

#define inp(p)		__inportb__(p)
#define inpw(p)		__inportw__(p)
#define inport(p)	__inportb__(p)
#define inportb(p)	__inportb__(p)
#define inportw(p)	__inportw__(p)
#define	outp(p,v)	__outportb__((p),(v))
#define outpw(p,v)	__outportw__((p),(v))
#define outport(p,v)	__outportb__((p),(v))
#define outportb(p,v)	__outportb__((p),(v))
#define outportw(p,v)	__outportw__((p),(v))

#endif



