/*
 * timed transitions
 *
 * provides synchronous image source consumption
 *
 * $Id: timed.c,v 1.8 2000/10/24 15:29:13 opencare Exp $
 *
 * Copyright (C) 2000 OpenCare (www.ocare.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#include "gfxtrans.h"

/* 
 * prepare an animation
 *
 * arg1: int duration
 * ... : passed to fifo (transition name, prev_img_source, next_img_source)
 *
 */
imgsource_t 
gfxtrans_timed_create(va_list ap) {
  imgsource_t timed_source = NULL;
  int duration;

  /* create an animated source */
  timed_source = (imgsource_t) malloc(sizeof(struct _imgsource_t));
  if (timed_source) {

    /* consume our arguments, trailing will be given to fifo */
    duration = va_arg(ap, int);

    /* create an asynchronous fifo */
    GFXTRANS_FIFO_T(timed_source).writer = gfxtrans_fifo_create(ap);
    if ( GFXTRANS_FIFO_T(timed_source).writer ) {

      /* initialize member functions */
      timed_source->create_f = gfxtrans_timed_create; /* nottin' more unusefull ? */
      timed_source->display_f = gfxtrans_timed_display;
      timed_source->destroy_f = gfxtrans_timed_destroy;

      /* initialize member datas */
      GFXTRANS_TIMED_T(timed_source).fifo = gfxtrans_fifo_create(timed_source);
      GFXTRANS_ANIMATED_T(timed_source).framerate = 0;
      GFXTRANS_ANIMATED_T(timed_source).frames = 1;
      GFXTRANS_ANIMATED_T(timed_source).timelength = duration;

      va_end(argv);

      /* advise calling thread we are ready to display */
      return timed_source;
    } else {
      /* can't create fifo */
    }
  } else {
    /* can't malloc imgsource_t */
  }
  return NULL;
}


/*
 * start displaying timed animation
 */
gfxtrans_display_t *
gfxtrans_timed_display(imgsource_t img_source, gfxtrans_display_t *fb) {
  return NULL;
}


void
gfxtrans_timed_destroy(imgsource_t img_source) {
}
