/*
 * temporary test program
 *
 * $Id: test.c,v 1.8 2000/11/03 16:11:49 opencare Exp $
 *
 * Copyright (C) 2000 OpenCare (www.ocare.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#include "gfxtrans.h"

#define WIDTH 640
#define HEIGHT 480
int
main(int argc, char **argv) {
  imgsource_t prev_source, next_source, scaled_prev_source, scaled_next_source, blocky_source, fifo_source;
  int return_code;

  /* init RNG */
  srand( time(0) );
  if( !gfxtrans_display_init(WIDTH, HEIGHT) ) {

    /* open 'previous' image */
    prev_source = gfxtrans_create(IMGSOURCE_JPEG, "blah.jpeg");
    if (prev_source) {
      gfxtrans_display(prev_source, NULL);

      /* open 'next' image */
      next_source = gfxtrans_create(IMGSOURCE_JPEG, "blah2.jpeg");
      if (next_source) {
	gfxtrans_display(next_source, NULL);

	/* scale 'previous' image */
	scaled_prev_source = gfxtrans_create(IMGSOURCE_SCALED, prev_source,
					     WIDTH, HEIGHT);
	if (scaled_prev_source) {
	  gfxtrans_display(scaled_prev_source, NULL);

	  /* scale 'next' image */
	  scaled_next_source = gfxtrans_create(IMGSOURCE_SCALED, next_source,
					       WIDTH, HEIGHT);
	  if (scaled_next_source) {
	    int loop;

	    gfxtrans_display(scaled_next_source, NULL);

	    for (loop = 0; loop < 1; loop++) {
	      imgsource_t swap = scaled_prev_source;

	      scaled_prev_source = scaled_next_source;
	      scaled_next_source = swap;

	      /* init block transition */
	      blocky_source = gfxtrans_create(IMGSOURCE_BLOCKY,
					      scaled_prev_source,
					      scaled_next_source,
					      0);

	      if (blocky_source) {
		int tick;

		/* create fifo */
		fifo_source = gfxtrans_create(IMGSOURCE_FIFO,
					      blocky_source);
		if (fifo_source) {

		  for (tick = 0; tick <= 50; tick ++) {
		    gfxtrans_display(fifo_source, NULL);
/*  		    sleep(2); */
		  }
/*  		  gfxtrans_display(next_source, NULL); */

		  sleep(2);
	    
		  /* will exit successfully */
		  return_code = 0;

		  gfxtrans_destroy(fifo_source);

		  /* error handling */

		} else {
		  fprintf(stderr, "can't create FIFO\n");
		  return_code = -1;
		}

		gfxtrans_destroy(blocky_source);

	      } else {
		fprintf(stderr, "can't create block transitions\n");
		return_code = -1;
	      }
	    }
	    gfxtrans_destroy(scaled_next_source);	  

	  } else {
	    fprintf(stderr, "can't scale next image\n");
	    return_code = -1;
	  }
	  gfxtrans_destroy(scaled_prev_source);

	} else {
	  fprintf(stderr, "can't scale prev image\n");
	}
	gfxtrans_destroy(next_source);	

      } else {
	fprintf(stderr, "can't create next image\n");
	return_code = -1;
      }
      gfxtrans_destroy(prev_source);

    } else {
      fprintf(stderr, "can't create image source\n");
      return_code = -1;
    }
    return_code = 0;
    gfxtrans_destroy(prev_source);
    gfxtrans_display_exit();
  } else {
    fprintf(stderr, "can't initialize libgfxtrans\n");
    return_code = -1;
  }

  exit(return_code);
}
