/*
 * image_source declarations, included in gfxtrans.h
 *
 * $Id: img_source.h,v 1.8 2000/11/03 16:10:44 opencare Exp $
 *
 * Copyright (C) 2000 OpenCare (www.ocare.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#ifndef IMG_SOURCE_H
#define IMG_SOURCE_H

#include <stdarg.h>

/* this gives a type to an image_source */
typedef enum {
  IMGSOURCE_TIMED,
  IMGSOURCE_FIFO,
  IMGSOURCE_TARGA,
  IMGSOURCE_JPEG,
  IMGSOURCE_BLOCKY,
  IMGSOURCE_SCALED,
  IMGSOURCE_UNKNOWN
} img_source_type_t;

typedef struct _imgsource_t *imgsource_t;

#include "timed.h"
#include "jpeg.h"
#include "fifo.h"
#include "blocky.h"
#include "scaled.h"


/* this gives access to virtual class fields */
#define GFXTRANS_STILL_T(imgsource) imgsource->kind.animated
#define GFXTRANS_ANIMATED_T(imgsource) imgsource->kind.animated

struct _imgsource_t {
  int width, height;		/* image dimensions, fixed */
  gfxtrans_display_t *display;	/* primary display to write to */
  img_source_type_t type;	/* type of this source */

  /* synchronisation flags */
  pthread_mutex_t img_ready_mutex;
  pthread_cond_t img_ready_cond;
  int ref_count;		/* reference count */
  int registered_readers;	/* how many readers for each frames */

  imgsource_t (*create_f) (va_list ap);
  gfxtrans_display_t * (*display_f) (imgsource_t img_source, gfxtrans_display_t *fb);
  int (*add_reader_f)(imgsource_t img_source);
  void (*destroy_f) (imgsource_t img_source);

  union {

    struct {
      union {

	/* named targa source */
	struct {
	  char *filename;	/* the original file name */
	} targa;

	/* named jpeg source */
	struct {
	  char *filename;	/* the original file name */
	} jpeg;

	/* scaled */
	struct {
	  int *weights;
	  int n_x;
	  int n_y;
	  double x_offset;
	  double y_offset;
	  imgsource_t img_source; /* whom to scale */
	} scaled;

      } kind;

    } still;

    struct {
      int framerate;		/* guess what ? */
      int frames;		/* number of frames to play */
      int tick;			/* which frame is actually rendered */
      int still;		/* whether animation is still */
      int timelength;		/* maximum total time to display, in seconds */

      union {

	/* fifo buffer */
	struct {
	  imgsource_t writer;	/* source filling the fifo */
	  int length;		/* number of frames in fifo */
	  int readindex;	/* current read frame */
	  int writeindex;	/* current wrote frame */
	  gfxtrans_display_t *frame[2]; /* framebuffers held */
	} fifo;

	/* timed image source */
	struct {
	  imgsource_t fifo;	/* fifo used to bufferize */
	} timed;

	/* blocky animation */
	struct {
	  imgsource_t prev;	/* previous source */
	  imgsource_t next;	/* next source */
	  int strides;		/* number of strides in animation */
	  int step;		/* step for animation */
	} blocky;

      } kind;

    } animated;

  } kind;
};

#endif /* IMG_SOURCE_H */
