/*
 * libgfxtrans main header
 *
 * provides references to transition objects
 *
 * $Id: gfxtrans.h,v 1.6 2000/10/23 11:11:43 opencare Exp $
 *
 * Copyright (C) 2000 OpenCare (www.ocare.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#ifndef GFXTRANS_H
#define GFXTRANS_H

#include "display.h"
#include "img_source.h"
#include "gfxlog.h"

/* utility functions, defined in common.c */
img_source_type_t gfxtrans_get_function_by_name(char *name);

imgsource_t gfxtrans_create(img_source_type_t transition, ...);
void gfxtrans_destroy (imgsource_t img_source);
gfxtrans_display_t *gfxtrans_display(imgsource_t img_source, gfxtrans_display_t *fb);

#endif /* GFXTRANS_H */
