/*
 * some log macro for debugging
 *
 * $Id: gfxlog.h,v 1.4 2000/11/03 16:15:51 opencare Exp $
 *
 * Copyright (C) 2000 OpenCare (www.ocare.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */


#ifndef GFXLOG_H
#define GFXLOG_H

#include <syslog.h>

#if DEBUG_LEVEL >= 1
#define gfx_log(priority, msg, args...) \
           syslog(priority, "<%10s, line %4d> " msg, __FILE__ , __LINE__ , ## args)
#else
#define gfx_log(priority, msg, args...) /* do nothing */
#endif

#endif /* GFXLOG_H*/
